/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin.sr;

import com.google.common.annotations.VisibleForTesting;
import com.provectus.kafka.ui.exception.ValidationException;
import com.provectus.kafka.ui.serde.api.DeserializeResult;
import com.provectus.kafka.ui.serde.api.PropertyResolver;
import com.provectus.kafka.ui.serde.api.SchemaDescription;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.serdes.BuiltInSerde;
import com.provectus.kafka.ui.serdes.builtin.sr.MessageFormatter;
import com.provectus.kafka.ui.serdes.builtin.sr.SchemaRegistrySerde;
import com.provectus.kafka.ui.serdes.builtin.sr.SchemaType;
import com.provectus.kafka.ui.serdes.builtin.sr.Serialize;
import com.provectus.kafka.ui.util.jsonschema.AvroJsonSchemaConverter;
import com.provectus.kafka.ui.util.jsonschema.ProtobufSchemaConverter;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaRegistrySerde
implements BuiltInSerde {
    private static final byte SR_PAYLOAD_MAGIC_BYTE = 0;
    private static final int SR_PAYLOAD_PREFIX_LENGTH = 5;
    private static final String SCHEMA_REGISTRY = "schemaRegistry";
    private SchemaRegistryClient schemaRegistryClient;
    private List<String> schemaRegistryUrls;
    private String valueSchemaNameTemplate;
    private String keySchemaNameTemplate;
    private boolean checkSchemaExistenceForDeserialize;
    private Map<SchemaType, MessageFormatter> schemaRegistryFormatters;

    public static String name() {
        return "SchemaRegistry";
    }

    public boolean canBeAutoConfigured(PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        return kafkaClusterProperties.getListProperty("schemaRegistry", String.class).filter(lst -> !lst.isEmpty()).isPresent();
    }

    public void autoConfigure(PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        List urls = kafkaClusterProperties.getListProperty("schemaRegistry", String.class).filter(lst -> !lst.isEmpty()).orElseThrow(() -> new ValidationException("No urls provided for schema registry"));
        this.configure(urls, SchemaRegistrySerde.createSchemaRegistryClient((List)urls, (String)kafkaClusterProperties.getProperty("schemaRegistryAuth.username", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("schemaRegistryAuth.password", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("schemaRegistrySsl.keystoreLocation", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("schemaRegistrySsl.keystorePassword", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("ssl.truststoreLocation", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("ssl.truststorePassword", String.class).orElse(null)), kafkaClusterProperties.getProperty("schemaRegistryKeySchemaNameTemplate", String.class).orElse("%s-key"), kafkaClusterProperties.getProperty("schemaRegistrySchemaNameTemplate", String.class).orElse("%s-value"), kafkaClusterProperties.getProperty("schemaRegistryCheckSchemaExistenceForDeserialize", Boolean.class).orElse(false).booleanValue());
    }

    public void configure(PropertyResolver serdeProperties, PropertyResolver kafkaClusterProperties, PropertyResolver globalProperties) {
        List urls = serdeProperties.getListProperty("url", String.class).or(() -> kafkaClusterProperties.getListProperty("schemaRegistry", String.class)).filter(lst -> !lst.isEmpty()).orElseThrow(() -> new ValidationException("No urls provided for schema registry"));
        this.configure(urls, SchemaRegistrySerde.createSchemaRegistryClient((List)urls, (String)serdeProperties.getProperty("username", String.class).orElse(null), (String)serdeProperties.getProperty("password", String.class).orElse(null), (String)serdeProperties.getProperty("keystoreLocation", String.class).orElse(null), (String)serdeProperties.getProperty("keystorePassword", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("ssl.truststoreLocation", String.class).orElse(null), (String)kafkaClusterProperties.getProperty("ssl.truststorePassword", String.class).orElse(null)), serdeProperties.getProperty("keySchemaNameTemplate", String.class).orElse("%s-key"), serdeProperties.getProperty("schemaNameTemplate", String.class).orElse("%s-value"), serdeProperties.getProperty("checkSchemaExistenceForDeserialize", Boolean.class).orElse(false).booleanValue());
    }

    @VisibleForTesting
    void configure(List<String> schemaRegistryUrls, SchemaRegistryClient schemaRegistryClient, String keySchemaNameTemplate, String valueSchemaNameTemplate, boolean checkTopicSchemaExistenceForDeserialize) {
        this.schemaRegistryUrls = schemaRegistryUrls;
        this.schemaRegistryClient = schemaRegistryClient;
        this.keySchemaNameTemplate = keySchemaNameTemplate;
        this.valueSchemaNameTemplate = valueSchemaNameTemplate;
        this.schemaRegistryFormatters = MessageFormatter.createMap((SchemaRegistryClient)schemaRegistryClient);
        this.checkSchemaExistenceForDeserialize = checkTopicSchemaExistenceForDeserialize;
    }

    private static SchemaRegistryClient createSchemaRegistryClient(List<String> urls, @Nullable String username, @Nullable String password, @Nullable String keyStoreLocation, @Nullable String keyStorePassword, @Nullable String trustStoreLocation, @Nullable String trustStorePassword) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        if (username != null && password != null) {
            configs.put("basic.auth.credentials.source", "USER_INFO");
            configs.put("basic.auth.user.info", username + ":" + password);
        } else {
            if (username != null) {
                throw new ValidationException("You specified username but do not specified password");
            }
            if (password != null) {
                throw new ValidationException("You specified password but do not specified username");
            }
        }
        if (trustStoreLocation != null && trustStorePassword != null) {
            configs.put("schema.registry.ssl.truststore.location", trustStoreLocation);
            configs.put("schema.registry.ssl.truststore.password", trustStorePassword);
        }
        if (keyStoreLocation != null && keyStorePassword != null) {
            configs.put("schema.registry.ssl.keystore.location", keyStoreLocation);
            configs.put("schema.registry.ssl.keystore.password", keyStorePassword);
            configs.put("schema.registry.ssl.key.password", keyStorePassword);
        }
        return new CachedSchemaRegistryClient(urls, 1000, List.of(new AvroSchemaProvider(), new ProtobufSchemaProvider(), new JsonSchemaProvider()), configs);
    }

    public Optional<String> getDescription() {
        return Optional.empty();
    }

    public boolean canDeserialize(String topic, Serde.Target type) {
        String subject = this.schemaSubject(topic, type);
        return !this.checkSchemaExistenceForDeserialize || this.getSchemaBySubject(subject).isPresent();
    }

    public boolean canSerialize(String topic, Serde.Target type) {
        String subject = this.schemaSubject(topic, type);
        return this.getSchemaBySubject(subject).isPresent();
    }

    public Optional<SchemaDescription> getSchema(String topic, Serde.Target type) {
        String subject = this.schemaSubject(topic, type);
        return this.getSchemaBySubject(subject).flatMap(schemaMetadata -> this.getSchemaById(schemaMetadata.getId()).map(parsedSchema -> new SchemaDescription(this.convertSchema(schemaMetadata, parsedSchema), Map.of("subject", subject, "schemaId", schemaMetadata.getId(), "latestVersion", schemaMetadata.getVersion(), "type", schemaMetadata.getSchemaType()))));
    }

    private String convertSchema(SchemaMetadata schema, ParsedSchema parsedSchema) {
        URI basePath = new URI((String)this.schemaRegistryUrls.get(0)).resolve(Integer.toString(schema.getId()));
        SchemaType schemaType = (SchemaType)SchemaType.fromString((String)schema.getSchemaType()).orElseThrow(() -> new IllegalStateException("Unknown schema type: " + schema.getSchemaType()));
        return switch (1.$SwitchMap$com$provectus$kafka$ui$serdes$builtin$sr$SchemaType[schemaType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new ProtobufSchemaConverter().convert(basePath, ((ProtobufSchema)parsedSchema).toDescriptor()).toJson();
            case 2 -> new AvroJsonSchemaConverter().convert(basePath, ((AvroSchema)parsedSchema).rawSchema()).toJson();
            case 3 -> ((JsonSchema)parsedSchema).rawSchema().toString();
        };
    }

    private Optional<ParsedSchema> getSchemaById(int id) {
        return this.wrapWith404Handler(() -> this.schemaRegistryClient.getSchemaById(id));
    }

    private Optional<SchemaMetadata> getSchemaBySubject(String subject) {
        return this.wrapWith404Handler(() -> this.schemaRegistryClient.getLatestSchemaMetadata(subject));
    }

    private <T> Optional<T> wrapWith404Handler(Callable<T> call) {
        try {
            return Optional.ofNullable(call.call());
        }
        catch (RestClientException restClientException) {
            if (restClientException.getStatus() == 404) {
                return Optional.empty();
            }
            throw new RuntimeException("Error calling SchemaRegistryClient", restClientException);
        }
    }

    private String schemaSubject(String topic, Serde.Target type) {
        return String.format(type == Serde.Target.KEY ? this.keySchemaNameTemplate : this.valueSchemaNameTemplate, topic);
    }

    public Serde.Serializer serializer(String topic, Serde.Target type) {
        String subject = this.schemaSubject(topic, type);
        SchemaMetadata meta = (SchemaMetadata)this.getSchemaBySubject(subject).orElseThrow(() -> new ValidationException(String.format("No schema for subject '%s' found", subject)));
        ParsedSchema schema = (ParsedSchema)this.getSchemaById(meta.getId()).orElseThrow(() -> new IllegalStateException(String.format("Schema found for id %s, subject '%s'", meta.getId(), subject)));
        SchemaType schemaType = (SchemaType)SchemaType.fromString((String)meta.getSchemaType()).orElseThrow(() -> new IllegalStateException("Unknown schema type: " + meta.getSchemaType()));
        return switch (1.$SwitchMap$com$provectus$kafka$ui$serdes$builtin$sr$SchemaType[schemaType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> input -> Serialize.serializeProto((SchemaRegistryClient)this.schemaRegistryClient, (String)topic, (Serde.Target)type, (ProtobufSchema)((ProtobufSchema)schema), (int)meta.getId(), (String)input);
            case 2 -> input -> Serialize.serializeAvro((AvroSchema)((AvroSchema)schema), (int)meta.getId(), (String)input);
            case 3 -> input -> Serialize.serializeJson((JsonSchema)((JsonSchema)schema), (int)meta.getId(), (String)input);
        };
    }

    public Serde.Deserializer deserializer(String topic, Serde.Target type) {
        return (headers, data) -> {
            int schemaId = this.extractSchemaIdFromMsg(data);
            SchemaType format = this.getMessageFormatBySchemaId(schemaId);
            MessageFormatter formatter = (MessageFormatter)this.schemaRegistryFormatters.get(format);
            return new DeserializeResult(formatter.format(topic, data), DeserializeResult.Type.JSON, Map.of("schemaId", schemaId, "type", format.name()));
        };
    }

    private SchemaType getMessageFormatBySchemaId(int schemaId) {
        return (SchemaType)this.getSchemaById(schemaId).map(ParsedSchema::schemaType).flatMap(SchemaType::fromString).orElseThrow(() -> new ValidationException(String.format("Schema for id '%d' not found ", schemaId)));
    }

    private int extractSchemaIdFromMsg(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (buffer.remaining() >= 5 && buffer.get() == 0) {
            return buffer.getInt();
        }
        throw new ValidationException(String.format("Data doesn't contain magic byte and schema id prefix, so it can't be deserialized with %s serde", SchemaRegistrySerde.name()));
    }
}

