/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serdes.builtin.sr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.util.annotation.KafkaClientInternalsDependant;
import com.provectus.kafka.ui.util.jsonschema.JsonAvroConversion;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufSerializer;
import io.confluent.kafka.serializers.subject.DefaultReferenceSubjectNameStrategy;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.everit.json.schema.ValidationException;

/*
 * Exception performing whole class analysis ignored.
 */
final class Serialize {
    private static final byte MAGIC = 0;
    private static final ObjectMapper JSON_SERIALIZE_MAPPER = Jackson.newObjectMapper();

    private Serialize() {
    }

    @KafkaClientInternalsDependant(value="AbstractKafkaJsonSchemaSerializer::serializeImpl")
    static byte[] serializeJson(JsonSchema schema, int schemaId, String value) {
        byte[] byArray;
        JsonNode json;
        try {
            json = JSON_SERIALIZE_MAPPER.readTree(value);
        }
        catch (JsonProcessingException e) {
            throw new com.provectus.kafka.ui.exception.ValidationException(String.format("'%s' is not valid json", value));
        }
        try {
            schema.validate((Object)json);
        }
        catch (ValidationException e) {
            throw new com.provectus.kafka.ui.exception.ValidationException(String.format("'%s' does not fit schema: %s", value, e.getAllMessages()));
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(0);
            out.write(Serialize.schemaId((int)schemaId));
            out.write(JSON_SERIALIZE_MAPPER.writeValueAsBytes((Object)json));
            byArray = out.toByteArray();
        }
        return byArray;
    }

    @KafkaClientInternalsDependant(value="AbstractKafkaProtobufSerializer::serializeImpl")
    static byte[] serializeProto(SchemaRegistryClient srClient, String topic, Serde.Target target, ProtobufSchema schema, int schemaId, String input) {
        byte[] byArray;
        boolean normalizeSchema = false;
        boolean autoRegisterSchema = false;
        boolean useLatestVersion = true;
        boolean latestCompatStrict = true;
        boolean skipKnownTypes = true;
        schema = AbstractKafkaProtobufSerializer.resolveDependencies((SchemaRegistryClient)srClient, (boolean)normalizeSchema, (boolean)autoRegisterSchema, (boolean)useLatestVersion, (boolean)latestCompatStrict, new HashMap(), (boolean)skipKnownTypes, (ReferenceSubjectNameStrategy)new DefaultReferenceSubjectNameStrategy(), (String)topic, (target == Serde.Target.KEY ? 1 : 0) != 0, (ProtobufSchema)schema);
        DynamicMessage.Builder builder = schema.newMessageBuilder();
        JsonFormat.parser().merge(input, (Message.Builder)builder);
        DynamicMessage message = builder.build();
        MessageIndexes indexes = schema.toMessageIndexes(message.getDescriptorForType().getFullName(), normalizeSchema);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(0);
            out.write(Serialize.schemaId((int)schemaId));
            out.write(indexes.toByteArray());
            message.writeTo((OutputStream)out);
            byArray = out.toByteArray();
        }
        return byArray;
    }

    @KafkaClientInternalsDependant(value="AbstractKafkaAvroSerializer::serializeImpl")
    static byte[] serializeAvro(AvroSchema schema, int schemaId, String input) {
        byte[] byArray;
        Object avroObject = JsonAvroConversion.convertJsonToAvro((String)input, (Schema)schema.rawSchema());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(0);
            out.write(Serialize.schemaId((int)schemaId));
            Schema rawSchema = schema.rawSchema();
            if (rawSchema.getType().equals((Object)Schema.Type.BYTES)) {
                Preconditions.checkState((boolean)(avroObject instanceof ByteBuffer), (Object)("Unrecognized bytes object of type: " + avroObject.getClass().getName()));
                out.write(((ByteBuffer)avroObject).array());
            } else {
                boolean useLogicalTypeConverters = true;
                BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
                DatumWriter writer = AvroSchemaUtils.getDatumWriter((Object)avroObject, (Schema)rawSchema, (boolean)useLogicalTypeConverters);
                writer.write(avroObject, (Encoder)encoder);
                encoder.flush();
            }
            byArray = out.toByteArray();
        }
        return byArray;
    }

    private static byte[] schemaId(int id) {
        return ByteBuffer.allocate(4).putInt(id).array();
    }
}

