/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.provectus.kafka.ui.model.ApplicationInfoBuildDTO;
import com.provectus.kafka.ui.model.ApplicationInfoDTO;
import com.provectus.kafka.ui.model.ApplicationInfoLatestReleaseDTO;
import com.provectus.kafka.ui.util.DynamicConfigOperations;
import com.provectus.kafka.ui.util.GithubReleaseInfo;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ApplicationInfoService {
    private final GithubReleaseInfo githubReleaseInfo = new GithubReleaseInfo();
    private final DynamicConfigOperations dynamicConfigOperations;
    private final BuildProperties buildProperties;
    private final GitProperties gitProperties;

    public ApplicationInfoService(DynamicConfigOperations dynamicConfigOperations, @Autowired(required=false) BuildProperties buildProperties, @Autowired(required=false) GitProperties gitProperties) {
        this.dynamicConfigOperations = dynamicConfigOperations;
        this.buildProperties = Optional.ofNullable(buildProperties).orElse(new BuildProperties(new Properties()));
        this.gitProperties = Optional.ofNullable(gitProperties).orElse(new GitProperties(new Properties()));
    }

    public ApplicationInfoDTO getApplicationInfo() {
        GithubReleaseInfo.GithubReleaseDto releaseInfo = this.githubReleaseInfo.get();
        return new ApplicationInfoDTO().build(this.getBuildInfo(releaseInfo)).enabledFeatures(this.getEnabledFeatures()).latestRelease(this.convert(releaseInfo));
    }

    private ApplicationInfoLatestReleaseDTO convert(GithubReleaseInfo.GithubReleaseDto releaseInfo) {
        return new ApplicationInfoLatestReleaseDTO().htmlUrl(releaseInfo.html_url()).publishedAt(releaseInfo.published_at()).versionTag(releaseInfo.tag_name());
    }

    private ApplicationInfoBuildDTO getBuildInfo(GithubReleaseInfo.GithubReleaseDto release) {
        return new ApplicationInfoBuildDTO().isLatestRelease(Boolean.valueOf(release.tag_name() != null && release.tag_name().equals(this.buildProperties.getVersion()))).commitId(this.gitProperties.getShortCommitId()).version(this.buildProperties.getVersion()).buildTime(this.buildProperties.getTime() != null ? DateTimeFormatter.ISO_INSTANT.format(this.buildProperties.getTime()) : null);
    }

    private List<ApplicationInfoDTO.EnabledFeaturesEnum> getEnabledFeatures() {
        ArrayList<ApplicationInfoDTO.EnabledFeaturesEnum> enabledFeatures = new ArrayList<ApplicationInfoDTO.EnabledFeaturesEnum>();
        if (this.dynamicConfigOperations.dynamicConfigEnabled()) {
            enabledFeatures.add(ApplicationInfoDTO.EnabledFeaturesEnum.DYNAMIC_CONFIG);
        }
        return enabledFeatures;
    }

    @Scheduled(fixedRateString="${github-release-info-update-rate:3600000}")
    public void updateGithubReleaseInfo() {
        this.githubReleaseInfo.refresh().block();
    }
}

