/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.provectus.kafka.ui.mapper.ClusterMapper;
import com.provectus.kafka.ui.model.ClusterDTO;
import com.provectus.kafka.ui.model.ClusterMetricsDTO;
import com.provectus.kafka.ui.model.ClusterStatsDTO;
import com.provectus.kafka.ui.model.InternalClusterState;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.ClustersStorage;
import com.provectus.kafka.ui.service.StatisticsCache;
import com.provectus.kafka.ui.service.StatisticsService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ClusterService {
    private static final Logger log = LoggerFactory.getLogger(ClusterService.class);
    private final StatisticsCache statisticsCache;
    private final ClustersStorage clustersStorage;
    private final ClusterMapper clusterMapper;
    private final StatisticsService statisticsService;

    public List<ClusterDTO> getClusters() {
        return this.clustersStorage.getKafkaClusters().stream().map(c -> this.clusterMapper.toCluster(new InternalClusterState(c, this.statisticsCache.get(c)))).collect(Collectors.toList());
    }

    public Mono<ClusterStatsDTO> getClusterStats(KafkaCluster cluster) {
        return Mono.justOrEmpty((Object)this.clusterMapper.toClusterStats(new InternalClusterState(cluster, this.statisticsCache.get(cluster))));
    }

    public Mono<ClusterMetricsDTO> getClusterMetrics(KafkaCluster cluster) {
        return Mono.just((Object)this.clusterMapper.toClusterMetrics(this.statisticsCache.get(cluster).getMetrics()));
    }

    public Mono<ClusterDTO> updateCluster(KafkaCluster cluster) {
        return this.statisticsService.updateCache(cluster).map(metrics -> this.clusterMapper.toCluster(new InternalClusterState(cluster, metrics)));
    }

    public ClusterService(StatisticsCache statisticsCache, ClustersStorage clustersStorage, ClusterMapper clusterMapper, StatisticsService statisticsService) {
        this.statisticsCache = statisticsCache;
        this.clustersStorage = clustersStorage;
        this.clusterMapper = clusterMapper;
        this.statisticsService = statisticsService;
    }
}

