/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.provectus.kafka.ui.service.ClustersStorage;
import com.provectus.kafka.ui.service.StatisticsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Component
public class ClustersStatisticsScheduler {
    private static final Logger log = LoggerFactory.getLogger(ClustersStatisticsScheduler.class);
    private final ClustersStorage clustersStorage;
    private final StatisticsService statisticsService;

    @Scheduled(fixedRateString="${kafka.update-metrics-rate-millis:30000}")
    public void updateStatistics() {
        Flux.fromIterable((Iterable)this.clustersStorage.getKafkaClusters()).parallel().runOn(Schedulers.parallel()).flatMap(cluster -> {
            log.debug("Start getting metrics for kafkaCluster: {}", (Object)cluster.getName());
            return this.statisticsService.updateCache(cluster).doOnSuccess(m -> log.debug("Metrics updated for cluster: {}", (Object)cluster.getName()));
        }).then().block();
    }

    public ClustersStatisticsScheduler(ClustersStorage clustersStorage, StatisticsService statisticsService) {
        this.clustersStorage = clustersStorage;
        this.statisticsService = statisticsService;
    }
}

