/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class KafkaConfigSanitizer {
    private static final String SANITIZED_VALUE = "******";
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private static final List<String> DEFAULT_PATTERNS_TO_SANITIZE = ImmutableList.builder().addAll((Iterable)KafkaConfigSanitizer.kafkaConfigKeysToSanitize()).add((Object[])new String[]{"basic.auth.user.info", "password", "secret", "token", "key", ".*credentials.*", "aws.access.*", "aws.secret.*", "aws.session.*"}).build();
    private final List<Pattern> sanitizeKeysPatterns;

    KafkaConfigSanitizer(@Value(value="${kafka.config.sanitizer.enabled:true}") boolean enabled, @Value(value="${kafka.config.sanitizer.patterns:}") List<String> patternsToSanitize) {
        this.sanitizeKeysPatterns = enabled ? KafkaConfigSanitizer.compile(patternsToSanitize.isEmpty() ? DEFAULT_PATTERNS_TO_SANITIZE : patternsToSanitize) : List.of();
    }

    private static List<Pattern> compile(Collection<String> patternStrings) {
        return patternStrings.stream().map(p -> KafkaConfigSanitizer.isRegex((String)p) ? Pattern.compile(p, 2) : Pattern.compile(".*" + p + "$", 2)).toList();
    }

    private static boolean isRegex(String str) {
        return Arrays.stream(REGEX_PARTS).anyMatch(str::contains);
    }

    private static Set<String> kafkaConfigKeysToSanitize() {
        ConfigDef configDef = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)configDef);
        SaslConfigs.addClientSaslSupport((ConfigDef)configDef);
        return configDef.configKeys().entrySet().stream().filter(entry -> ((ConfigDef.ConfigKey)entry.getValue()).type().equals((Object)ConfigDef.Type.PASSWORD)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Nullable
    public Object sanitize(String key, @Nullable Object value) {
        for (Pattern pattern : this.sanitizeKeysPatterns) {
            if (!pattern.matcher(key).matches()) continue;
            return "******";
        }
        return value;
    }

    public Map<String, Object> sanitizeConnectorConfig(@Nullable Map<String, Object> original) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (original != null) {
            original.forEach((k, v) -> result.put((String)k, this.sanitize(k, v)));
        }
        return result;
    }
}

