/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service;

import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.ServerStatusDTO;
import com.provectus.kafka.ui.model.Statistics;
import com.provectus.kafka.ui.service.ClustersStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.springframework.stereotype.Component;

@Component
public class StatisticsCache {
    private final Map<String, Statistics> cache = new ConcurrentHashMap();

    public StatisticsCache(ClustersStorage clustersStorage) {
        Statistics initializing = Statistics.empty().toBuilder().status(ServerStatusDTO.INITIALIZING).build();
        clustersStorage.getKafkaClusters().forEach(c -> this.cache.put(c.getName(), initializing));
    }

    public synchronized void replace(KafkaCluster c, Statistics stats) {
        this.cache.put(c.getName(), stats);
    }

    public synchronized void update(KafkaCluster c, Map<String, TopicDescription> descriptions, Map<String, List<ConfigEntry>> configs) {
        Statistics metrics = this.get(c);
        HashMap<String, TopicDescription> updatedDescriptions = new HashMap<String, TopicDescription>(metrics.getTopicDescriptions());
        updatedDescriptions.putAll(descriptions);
        HashMap<String, List<ConfigEntry>> updatedConfigs = new HashMap<String, List<ConfigEntry>>(metrics.getTopicConfigs());
        updatedConfigs.putAll(configs);
        this.replace(c, metrics.toBuilder().topicDescriptions(updatedDescriptions).topicConfigs(updatedConfigs).build());
    }

    public synchronized void onTopicDelete(KafkaCluster c, String topic) {
        Statistics metrics = this.get(c);
        HashMap updatedDescriptions = new HashMap(metrics.getTopicDescriptions());
        updatedDescriptions.remove(topic);
        HashMap updatedConfigs = new HashMap(metrics.getTopicConfigs());
        updatedConfigs.remove(topic);
        this.replace(c, metrics.toBuilder().topicDescriptions(updatedDescriptions).topicConfigs(updatedConfigs).build());
    }

    public Statistics get(KafkaCluster c) {
        return Objects.requireNonNull((Statistics)this.cache.get(c.getName()), "Unknown cluster metrics requested");
    }
}

