/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.analyze;

import com.provectus.kafka.ui.model.TopicAnalysisStatsDTO;
import com.provectus.kafka.ui.service.analyze.TopicAnalysisStats;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;

/*
 * Exception performing whole class analysis ignored.
 */
class TopicAnalysisStats {
    Long totalMsgs = 0L;
    Long minOffset;
    Long maxOffset;
    Long minTimestamp;
    Long maxTimestamp;
    long nullKeys = 0L;
    long nullValues = 0L;
    final SizeStats keysSize = new SizeStats();
    final SizeStats valuesSize = new SizeStats();
    final HllSketch uniqKeys = new HllSketch();
    final HllSketch uniqValues = new HllSketch();
    final HourlyCounts hourlyCounts = new HourlyCounts();

    TopicAnalysisStats() {
    }

    void apply(ConsumerRecord<Bytes, Bytes> rec) {
        Long l = this.totalMsgs;
        this.totalMsgs = this.totalMsgs + 1L;
        this.minTimestamp = TopicAnalysisStats.minNullable((Long)this.minTimestamp, (long)rec.timestamp());
        this.maxTimestamp = TopicAnalysisStats.maxNullable((Long)this.maxTimestamp, (long)rec.timestamp());
        this.minOffset = TopicAnalysisStats.minNullable((Long)this.minOffset, (long)rec.offset());
        this.maxOffset = TopicAnalysisStats.maxNullable((Long)this.maxOffset, (long)rec.offset());
        this.hourlyCounts.apply(rec);
        if (rec.key() != null) {
            byte[] keyBytes = ((Bytes)rec.key()).get();
            this.keysSize.apply(rec.serializedKeySize());
            this.uniqKeys.update(keyBytes);
        } else {
            ++this.nullKeys;
        }
        if (rec.value() != null) {
            byte[] valueBytes = ((Bytes)rec.value()).get();
            this.valuesSize.apply(rec.serializedValueSize());
            this.uniqValues.update(valueBytes);
        } else {
            ++this.nullValues;
        }
    }

    TopicAnalysisStatsDTO toDto(@Nullable Integer partition) {
        return new TopicAnalysisStatsDTO().partition(partition).totalMsgs(this.totalMsgs).minOffset(this.minOffset).maxOffset(this.maxOffset).minTimestamp(this.minTimestamp).maxTimestamp(this.maxTimestamp).nullKeys(Long.valueOf(this.nullKeys)).nullValues(Long.valueOf(this.nullValues)).approxUniqKeys(Long.valueOf(Math.min(this.totalMsgs, (long)this.uniqKeys.getEstimate()))).approxUniqValues(Long.valueOf(Math.min(this.totalMsgs, (long)this.uniqValues.getEstimate()))).keySize(this.keysSize.toDto()).valueSize(this.valuesSize.toDto()).hourlyMsgCounts(this.hourlyCounts.toDto());
    }

    private static Long maxNullable(@Nullable Long v1, long v2) {
        return v1 == null ? v2 : Math.max(v1, v2);
    }

    private static Long minNullable(@Nullable Long v1, long v2) {
        return v1 == null ? v2 : Math.min(v1, v2);
    }
}

