/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.service.KafkaConnectService;
import com.provectus.kafka.ui.service.StatisticsCache;
import com.provectus.kafka.ui.service.integration.odd.ConnectorsExporter;
import com.provectus.kafka.ui.service.integration.odd.OddIntegrationProperties;
import com.provectus.kafka.ui.service.integration.odd.Oddrn;
import com.provectus.kafka.ui.service.integration.odd.TopicsExporter;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.opendatadiscovery.client.ApiClient;
import org.opendatadiscovery.client.api.OpenDataDiscoveryIngestionApi;
import org.opendatadiscovery.client.model.DataEntityList;
import org.opendatadiscovery.client.model.DataSource;
import org.opendatadiscovery.client.model.DataSourceList;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
class OddExporter {
    private final OpenDataDiscoveryIngestionApi oddApi;
    private final TopicsExporter topicsExporter;
    private final ConnectorsExporter connectorsExporter;

    public OddExporter(StatisticsCache statisticsCache, KafkaConnectService connectService, OddIntegrationProperties oddIntegrationProperties) {
        this(OddExporter.createApiClient((OddIntegrationProperties)oddIntegrationProperties), new TopicsExporter(OddExporter.createTopicsFilter((OddIntegrationProperties)oddIntegrationProperties), statisticsCache), new ConnectorsExporter(connectService));
    }

    @VisibleForTesting
    OddExporter(OpenDataDiscoveryIngestionApi oddApi, TopicsExporter topicsExporter, ConnectorsExporter connectorsExporter) {
        this.oddApi = oddApi;
        this.topicsExporter = topicsExporter;
        this.connectorsExporter = connectorsExporter;
    }

    private static Predicate<String> createTopicsFilter(OddIntegrationProperties properties) {
        if (properties.getTopicsRegex() == null) {
            return topic -> !topic.startsWith("_");
        }
        Pattern pattern = Pattern.compile(properties.getTopicsRegex());
        return topic -> pattern.matcher((CharSequence)topic).matches();
    }

    private static OpenDataDiscoveryIngestionApi createApiClient(OddIntegrationProperties properties) {
        Preconditions.checkNotNull((Object)properties.getUrl(), (Object)"ODD url not set");
        Preconditions.checkNotNull((Object)properties.getToken(), (Object)"ODD token not set");
        ApiClient apiClient = new ApiClient().setBasePath(properties.getUrl()).addDefaultHeader("Authorization", "Bearer " + properties.getToken());
        return new OpenDataDiscoveryIngestionApi(apiClient);
    }

    public Mono<Void> export(KafkaCluster cluster) {
        return this.exportTopics(cluster).then(this.exportKafkaConnects(cluster));
    }

    private Mono<Void> exportTopics(KafkaCluster c) {
        return this.createKafkaDataSource(c).thenMany((Publisher)this.topicsExporter.export(c)).concatMap(arg_0 -> this.sendDataEntities(arg_0)).then();
    }

    private Mono<Void> exportKafkaConnects(KafkaCluster cluster) {
        return this.createConnectDataSources(cluster).thenMany((Publisher)this.connectorsExporter.export(cluster)).concatMap(arg_0 -> this.sendDataEntities(arg_0)).then();
    }

    private Mono<Void> createConnectDataSources(KafkaCluster cluster) {
        return this.connectorsExporter.getConnectDataSources(cluster).buffer(100).concatMap(dataSources -> this.oddApi.createDataSource(new DataSourceList().items(dataSources))).then();
    }

    private Mono<Void> createKafkaDataSource(KafkaCluster cluster) {
        String clusterOddrn = Oddrn.clusterOddrn((KafkaCluster)cluster);
        return this.oddApi.createDataSource(new DataSourceList().addItemsItem(new DataSource().oddrn(clusterOddrn).name(cluster.getName()).description("Kafka cluster")));
    }

    private Mono<Void> sendDataEntities(DataEntityList dataEntityList) {
        return this.oddApi.postDataEntityList(dataEntityList);
    }
}

