/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd.schema;

import com.google.common.collect.ImmutableSet;
import com.provectus.kafka.ui.service.integration.odd.schema.AvroExtractor;
import com.provectus.kafka.ui.service.integration.odd.schema.DataSetFieldsExtractors;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.opendatadiscovery.client.model.DataSetField;
import org.opendatadiscovery.client.model.DataSetFieldType;
import org.opendatadiscovery.oddrn.model.KafkaPath;

/*
 * Exception performing whole class analysis ignored.
 */
final class AvroExtractor {
    private AvroExtractor() {
    }

    static List<DataSetField> extract(AvroSchema avroSchema, KafkaPath topicOddrn, boolean isKey) {
        Schema schema = avroSchema.rawSchema();
        ArrayList<DataSetField> result = new ArrayList<DataSetField>();
        result.add(DataSetFieldsExtractors.rootField((KafkaPath)topicOddrn, (boolean)isKey));
        AvroExtractor.extract((Schema)schema, (String)(topicOddrn.oddrn() + "/columns/" + (isKey ? "key" : "value")), null, null, null, (Boolean)false, (ImmutableSet)ImmutableSet.of(), result);
        return result;
    }

    private static void extract(Schema schema, String parentOddr, String oddrn, String name, String doc, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        switch (1.$SwitchMap$org$apache$avro$Schema$Type[schema.getType().ordinal()]) {
            case 1: {
                AvroExtractor.extractRecord((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (String)doc, (Boolean)nullable, registeredRecords, sink);
                break;
            }
            case 2: {
                AvroExtractor.extractUnion((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (String)doc, registeredRecords, sink);
                break;
            }
            case 3: {
                AvroExtractor.extractArray((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (String)doc, (Boolean)nullable, registeredRecords, sink);
                break;
            }
            case 4: {
                AvroExtractor.extractMap((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (String)doc, (Boolean)nullable, registeredRecords, sink);
                break;
            }
            default: {
                AvroExtractor.extractPrimitive((Schema)schema, (String)parentOddr, (String)oddrn, (String)name, (String)doc, (Boolean)nullable, sink);
            }
        }
    }

    private static DataSetField createDataSetField(String name, String doc, String parentOddrn, String oddrn, Schema schema, Boolean nullable) {
        return new DataSetField().name(name).description(doc).parentFieldOddrn(parentOddrn).oddrn(oddrn).type(AvroExtractor.mapSchema((Schema)schema, (Boolean)nullable));
    }

    private static void extractRecord(Schema schema, String parentOddr, String oddrn, String name, String doc, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        boolean isRoot;
        boolean bl = isRoot = oddrn == null;
        if (!isRoot) {
            sink.add(AvroExtractor.createDataSetField((String)name, (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)nullable));
            if (registeredRecords.contains((Object)schema.getFullName())) {
                return;
            }
        }
        ImmutableSet newRegisteredRecords = ImmutableSet.builder().addAll(registeredRecords).add((Object)schema.getFullName()).build();
        schema.getFields().forEach(f -> AvroExtractor.extract((Schema)f.schema(), (String)(isRoot ? parentOddr : oddrn), (String)(isRoot ? parentOddr + "/" + f.name() : oddrn + "/fields/" + f.name()), (String)f.name(), (String)f.doc(), (Boolean)false, (ImmutableSet)newRegisteredRecords, (List)sink));
    }

    private static void extractUnion(Schema schema, String parentOddr, String oddrn, String name, String doc, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        boolean containsNull = schema.getTypes().stream().map(Schema::getType).anyMatch(t -> t == Schema.Type.NULL);
        if (!isRoot && containsNull && schema.getTypes().size() == 2) {
            Schema nonNullSchema = schema.getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).findFirst().orElseThrow(IllegalStateException::new);
            AvroExtractor.extract((Schema)nonNullSchema, (String)parentOddr, (String)oddrn, (String)name, (String)doc, (Boolean)true, registeredRecords, sink);
            return;
        }
        Object object = oddrn = isRoot ? parentOddr + "/union" : oddrn;
        if (isRoot) {
            sink.add(AvroExtractor.createDataSetField((String)"Avro root union", (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)containsNull));
        } else {
            sink.add(AvroExtractor.createDataSetField((String)name, (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)containsNull));
        }
        for (Schema t2 : schema.getTypes()) {
            if (t2.getType() == Schema.Type.NULL) continue;
            AvroExtractor.extract((Schema)t2, (String)oddrn, (String)((String)oddrn + "/values/" + t2.getName()), (String)t2.getName(), (String)t2.getDoc(), (Boolean)containsNull, registeredRecords, sink);
        }
    }

    private static void extractArray(Schema schema, String parentOddr, String oddrn, String name, String doc, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        Object object = oddrn = isRoot ? parentOddr + "/array" : oddrn;
        if (isRoot) {
            sink.add(AvroExtractor.createDataSetField((String)"Avro root Array", (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)nullable));
        } else {
            sink.add(AvroExtractor.createDataSetField((String)name, (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)nullable));
        }
        AvroExtractor.extract((Schema)schema.getElementType(), (String)oddrn, (String)((String)oddrn + "/items/" + schema.getElementType().getName()), (String)schema.getElementType().getName(), (String)schema.getElementType().getDoc(), (Boolean)false, registeredRecords, sink);
    }

    private static void extractMap(Schema schema, String parentOddr, String oddrn, String name, String doc, Boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        boolean isRoot = oddrn == null;
        Object object = oddrn = isRoot ? parentOddr + "/map" : oddrn;
        if (isRoot) {
            sink.add(AvroExtractor.createDataSetField((String)"Avro root map", (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)nullable));
        } else {
            sink.add(AvroExtractor.createDataSetField((String)name, (String)doc, (String)parentOddr, (String)oddrn, (Schema)schema, (Boolean)nullable));
        }
        AvroExtractor.extract((Schema)new Schema.Parser().parse("\"string\""), (String)oddrn, (String)((String)oddrn + "/key"), (String)"key", null, (Boolean)nullable, registeredRecords, sink);
        AvroExtractor.extract((Schema)schema.getValueType(), (String)oddrn, (String)((String)oddrn + "/value"), (String)"value", null, (Boolean)nullable, registeredRecords, sink);
    }

    private static void extractPrimitive(Schema schema, String parentOddr, String oddrn, String name, String doc, Boolean nullable, List<DataSetField> sink) {
        String primOddrn;
        boolean isRoot = oddrn == null;
        String string = primOddrn = isRoot ? parentOddr + "/" + schema.getType() : oddrn;
        if (isRoot) {
            sink.add(AvroExtractor.createDataSetField((String)("Root avro " + schema.getType()), (String)doc, (String)parentOddr, (String)primOddrn, (Schema)schema, (Boolean)nullable));
        } else {
            sink.add(AvroExtractor.createDataSetField((String)name, (String)doc, (String)parentOddr, (String)primOddrn, (Schema)schema, (Boolean)nullable));
        }
    }

    private static DataSetFieldType.TypeEnum mapType(Schema.Type type) {
        return switch (1.$SwitchMap$org$apache$avro$Schema$Type[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 5, 6 -> DataSetFieldType.TypeEnum.INTEGER;
            case 7, 8, 9 -> DataSetFieldType.TypeEnum.NUMBER;
            case 10, 11 -> DataSetFieldType.TypeEnum.STRING;
            case 12 -> DataSetFieldType.TypeEnum.BOOLEAN;
            case 13 -> DataSetFieldType.TypeEnum.BINARY;
            case 3 -> DataSetFieldType.TypeEnum.LIST;
            case 1 -> DataSetFieldType.TypeEnum.STRUCT;
            case 4 -> DataSetFieldType.TypeEnum.MAP;
            case 2 -> DataSetFieldType.TypeEnum.UNION;
            case 14 -> DataSetFieldType.TypeEnum.UNKNOWN;
        };
    }

    private static DataSetFieldType mapSchema(Schema schema, Boolean nullable) {
        return new DataSetFieldType().logicalType(AvroExtractor.logicalType((Schema)schema)).isNullable(nullable).type(AvroExtractor.mapType((Schema.Type)schema.getType()));
    }

    private static String logicalType(Schema schema) {
        return schema.getType() == Schema.Type.RECORD ? schema.getFullName() : schema.getType().toString().toLowerCase();
    }
}

