/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd.schema;

import com.provectus.kafka.ui.service.integration.odd.schema.AvroExtractor;
import com.provectus.kafka.ui.service.integration.odd.schema.DataSetFieldsExtractors;
import com.provectus.kafka.ui.service.integration.odd.schema.JsonSchemaExtractor;
import com.provectus.kafka.ui.service.integration.odd.schema.ProtoExtractor;
import com.provectus.kafka.ui.sr.model.SchemaSubject;
import com.provectus.kafka.ui.sr.model.SchemaType;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendatadiscovery.client.model.DataSetField;
import org.opendatadiscovery.client.model.DataSetFieldType;
import org.opendatadiscovery.oddrn.model.KafkaPath;

public final class DataSetFieldsExtractors {
    public static List<DataSetField> extract(SchemaSubject subject, Map<String, String> resolvedRefs, KafkaPath topicOddrn, boolean isKey) {
        SchemaType schemaType = Optional.ofNullable(subject.getSchemaType()).orElse(SchemaType.AVRO);
        return switch (1.$SwitchMap$com$provectus$kafka$ui$sr$model$SchemaType[schemaType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> AvroExtractor.extract((AvroSchema)new AvroSchema(subject.getSchema(), List.of(), resolvedRefs, null), (KafkaPath)topicOddrn, (boolean)isKey);
            case 2 -> JsonSchemaExtractor.extract((JsonSchema)new JsonSchema(subject.getSchema(), List.of(), resolvedRefs, null), (KafkaPath)topicOddrn, (boolean)isKey);
            case 3 -> ProtoExtractor.extract((ProtobufSchema)new ProtobufSchema(subject.getSchema(), List.of(), resolvedRefs, null, null), (KafkaPath)topicOddrn, (boolean)isKey);
        };
    }

    static DataSetField rootField(KafkaPath topicOddrn, boolean isKey) {
        String rootOddrn = topicOddrn.oddrn() + "/columns/" + (isKey ? "key" : "value");
        return new DataSetField().name(isKey ? "key" : "value").description("Topic's " + (isKey ? "key" : "value") + " schema").parentFieldOddrn(topicOddrn.oddrn()).oddrn(rootOddrn).type(new DataSetFieldType().type(DataSetFieldType.TypeEnum.STRUCT).isNullable(Boolean.valueOf(true)));
    }
}

