/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.integration.odd.schema;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.provectus.kafka.ui.service.integration.odd.schema.DataSetFieldsExtractors;
import com.provectus.kafka.ui.service.integration.odd.schema.ProtoExtractor;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opendatadiscovery.client.model.DataSetField;
import org.opendatadiscovery.client.model.DataSetFieldType;
import org.opendatadiscovery.oddrn.model.KafkaPath;

/*
 * Exception performing whole class analysis ignored.
 */
final class ProtoExtractor {
    private static final Set<String> PRIMITIVES_WRAPPER_TYPE_NAMES = Set.of(BoolValue.getDescriptor().getFullName(), Int32Value.getDescriptor().getFullName(), UInt32Value.getDescriptor().getFullName(), Int64Value.getDescriptor().getFullName(), UInt64Value.getDescriptor().getFullName(), StringValue.getDescriptor().getFullName(), BytesValue.getDescriptor().getFullName(), FloatValue.getDescriptor().getFullName(), DoubleValue.getDescriptor().getFullName());

    private ProtoExtractor() {
    }

    static List<DataSetField> extract(ProtobufSchema protobufSchema, KafkaPath topicOddrn, boolean isKey) {
        Descriptors.Descriptor schema = protobufSchema.toDescriptor();
        ArrayList<DataSetField> result = new ArrayList<DataSetField>();
        result.add(DataSetFieldsExtractors.rootField((KafkaPath)topicOddrn, (boolean)isKey));
        String rootOddrn = topicOddrn.oddrn() + "/columns/" + (isKey ? "key" : "value");
        schema.getFields().forEach(f -> ProtoExtractor.extract((Descriptors.FieldDescriptor)f, (String)rootOddrn, (String)(rootOddrn + "/" + f.getName()), (String)f.getName(), (!f.isRequired() ? 1 : 0) != 0, (boolean)f.isRepeated(), (ImmutableSet)ImmutableSet.of((Object)schema.getFullName()), (List)result));
        return result;
    }

    private static void extract(Descriptors.FieldDescriptor field, String parentOddr, String oddrn, String name, boolean nullable, boolean repeated, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        if (repeated) {
            ProtoExtractor.extractRepeated((Descriptors.FieldDescriptor)field, (String)parentOddr, (String)oddrn, (String)name, (boolean)nullable, registeredRecords, sink);
        } else if (field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            ProtoExtractor.extractMessage((Descriptors.FieldDescriptor)field, (String)parentOddr, (String)oddrn, (String)name, (boolean)nullable, registeredRecords, sink);
        } else {
            ProtoExtractor.extractPrimitive((Descriptors.FieldDescriptor)field, (String)parentOddr, (String)oddrn, (String)name, (boolean)nullable, sink);
        }
    }

    private static boolean extractProtoWellKnownType(Descriptors.FieldDescriptor field, String parentOddr, String oddrn, String name, boolean nullable, List<DataSetField> sink) {
        if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
            return false;
        }
        String typeName = field.getMessageType().getFullName();
        if (typeName.equals(Timestamp.getDescriptor().getFullName())) {
            sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.DATETIME, (String)typeName, (Boolean)nullable));
            return true;
        }
        if (typeName.equals(Duration.getDescriptor().getFullName())) {
            sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.DURATION, (String)typeName, (Boolean)nullable));
            return true;
        }
        if (typeName.equals(Value.getDescriptor().getFullName())) {
            sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.UNKNOWN, (String)typeName, (Boolean)nullable));
            return true;
        }
        if (PRIMITIVES_WRAPPER_TYPE_NAMES.contains(typeName)) {
            Descriptors.FieldDescriptor wrapped = field.getMessageType().findFieldByName("value");
            sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)ProtoExtractor.mapType((Descriptors.FieldDescriptor.Type)wrapped.getType()), (String)typeName, (Boolean)true));
            return true;
        }
        return false;
    }

    private static void extractRepeated(Descriptors.FieldDescriptor field, String parentOddr, String oddrn, String name, boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.LIST, (String)"repeated", (Boolean)nullable));
        String itemName = field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE ? field.getMessageType().getName() : field.getType().name().toLowerCase();
        ProtoExtractor.extract((Descriptors.FieldDescriptor)field, (String)oddrn, (String)(oddrn + "/items/" + itemName), (String)itemName, (boolean)nullable, (boolean)false, registeredRecords, sink);
    }

    private static void extractMessage(Descriptors.FieldDescriptor field, String parentOddr, String oddrn, String name, boolean nullable, ImmutableSet<String> registeredRecords, List<DataSetField> sink) {
        if (ProtoExtractor.extractProtoWellKnownType((Descriptors.FieldDescriptor)field, (String)parentOddr, (String)oddrn, (String)name, (boolean)nullable, sink)) {
            return;
        }
        sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)DataSetFieldType.TypeEnum.STRUCT, (String)ProtoExtractor.getLogicalTypeName((Descriptors.FieldDescriptor)field), (Boolean)nullable));
        String msgTypeName = field.getMessageType().getFullName();
        if (registeredRecords.contains((Object)msgTypeName)) {
            return;
        }
        ImmutableSet newRegisteredRecords = ImmutableSet.builder().addAll(registeredRecords).add((Object)msgTypeName).build();
        field.getMessageType().getFields().forEach(f -> ProtoExtractor.extract((Descriptors.FieldDescriptor)f, (String)oddrn, (String)(oddrn + "/fields/" + f.getName()), (String)f.getName(), (!f.isRequired() ? 1 : 0) != 0, (boolean)f.isRepeated(), (ImmutableSet)newRegisteredRecords, (List)sink));
    }

    private static void extractPrimitive(Descriptors.FieldDescriptor field, String parentOddr, String oddrn, String name, boolean nullable, List<DataSetField> sink) {
        sink.add(ProtoExtractor.createDataSetField((String)name, (String)parentOddr, (String)oddrn, (DataSetFieldType.TypeEnum)ProtoExtractor.mapType((Descriptors.FieldDescriptor.Type)field.getType()), (String)ProtoExtractor.getLogicalTypeName((Descriptors.FieldDescriptor)field), (Boolean)nullable));
    }

    private static String getLogicalTypeName(Descriptors.FieldDescriptor f) {
        return f.getType() == Descriptors.FieldDescriptor.Type.MESSAGE ? f.getMessageType().getFullName() : f.getType().name().toLowerCase();
    }

    private static DataSetField createDataSetField(String name, String parentOddrn, String oddrn, DataSetFieldType.TypeEnum type, String logicalType, Boolean nullable) {
        return new DataSetField().name(name).parentFieldOddrn(parentOddrn).oddrn(oddrn).type(new DataSetFieldType().isNullable(nullable).logicalType(logicalType).type(type));
    }

    private static DataSetFieldType.TypeEnum mapType(Descriptors.FieldDescriptor.Type type) {
        return switch (1.$SwitchMap$com$google$protobuf$Descriptors$FieldDescriptor$Type[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> DataSetFieldType.TypeEnum.INTEGER;
            case 11, 12 -> DataSetFieldType.TypeEnum.NUMBER;
            case 13, 14 -> DataSetFieldType.TypeEnum.STRING;
            case 15 -> DataSetFieldType.TypeEnum.BOOLEAN;
            case 16 -> DataSetFieldType.TypeEnum.BINARY;
            case 17, 18 -> DataSetFieldType.TypeEnum.STRUCT;
        };
    }
}

