/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.masking;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.config.ClustersProperties;
import com.provectus.kafka.ui.model.TopicMessageDTO;
import com.provectus.kafka.ui.serde.api.Serde;
import com.provectus.kafka.ui.service.masking.DataMasking;
import com.provectus.kafka.ui.service.masking.policies.MaskingPolicy;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DataMasking {
    private static final JsonMapper JSON_MAPPER = new JsonMapper();
    private final List<Mask> masks;

    public static DataMasking create(@Nullable List<ClustersProperties.Masking> config) {
        return new DataMasking(Optional.ofNullable(config).orElse(List.of()).stream().map(property -> {
            Preconditions.checkNotNull((Object)property.getType(), (Object)"masking type not specified");
            Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)property.getTopicKeysPattern()) || StringUtils.isNotEmpty((CharSequence)property.getTopicValuesPattern()) ? 1 : 0) != 0, (Object)"topicKeysPattern or topicValuesPattern (or both) should be set for masking policy");
            return new Mask((Pattern)Optional.ofNullable(property.getTopicKeysPattern()).map(Pattern::compile).orElse(null), (Pattern)Optional.ofNullable(property.getTopicValuesPattern()).map(Pattern::compile).orElse(null), MaskingPolicy.create((ClustersProperties.Masking)property));
        }).toList());
    }

    @VisibleForTesting
    DataMasking(List<Mask> masks) {
        this.masks = masks;
    }

    public UnaryOperator<TopicMessageDTO> getMaskerForTopic(String topic) {
        UnaryOperator keyMasker = this.getMaskingFunction(topic, Serde.Target.KEY);
        UnaryOperator valMasker = this.getMaskingFunction(topic, Serde.Target.VALUE);
        return msg -> msg.key((String)keyMasker.apply(msg.getKey())).content((String)valMasker.apply(msg.getContent()));
    }

    @VisibleForTesting
    UnaryOperator<String> getMaskingFunction(String topic, Serde.Target target) {
        List<Mask> targetMasks = this.masks.stream().filter(m -> m.shouldBeApplied(topic, target)).toList();
        if (targetMasks.isEmpty()) {
            return UnaryOperator.identity();
        }
        return inputStr -> {
            if (inputStr == null) {
                return null;
            }
            try {
                JsonNode json = JSON_MAPPER.readTree(inputStr);
                if (json.isContainerNode()) {
                    for (Mask targetMask : targetMasks) {
                        json = targetMask.policy.applyToJsonContainer((ContainerNode)json);
                    }
                    return json.toString();
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return ((Mask)targetMasks.get((int)0)).policy.applyToString(inputStr);
        };
    }
}

