/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.masking.policies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.service.masking.policies.FieldsSelector;
import com.provectus.kafka.ui.service.masking.policies.MaskingPolicy;
import java.util.List;
import java.util.function.UnaryOperator;

/*
 * Exception performing whole class analysis ignored.
 */
class Mask
extends MaskingPolicy {
    static final List<String> DEFAULT_PATTERN = List.of("X", "x", "n", "-");
    private final UnaryOperator<String> masker;

    Mask(FieldsSelector fieldsSelector, List<String> maskingChars) {
        super(fieldsSelector);
        this.masker = Mask.createMasker(maskingChars);
    }

    public ContainerNode<?> applyToJsonContainer(ContainerNode<?> node) {
        return (ContainerNode)this.maskWithFieldsCheck(node);
    }

    public String applyToString(String str) {
        return (String)this.masker.apply(str);
    }

    private static UnaryOperator<String> createMasker(List<String> maskingChars) {
        Preconditions.checkNotNull(maskingChars);
        Preconditions.checkArgument((maskingChars.size() == 4 ? 1 : 0) != 0, (Object)"mask pattern should contain 4 elements");
        return input -> {
            StringBuilder sb = new StringBuilder(input.length());
            block6: for (int i = 0; i < input.length(); ++i) {
                int cp = input.codePointAt(i);
                switch (Character.getType(cp)) {
                    case 12: 
                    case 13: 
                    case 14: {
                        sb.appendCodePoint(cp);
                        continue block6;
                    }
                    case 1: {
                        sb.append((String)maskingChars.get(0));
                        continue block6;
                    }
                    case 2: {
                        sb.append((String)maskingChars.get(1));
                        continue block6;
                    }
                    case 9: {
                        sb.append((String)maskingChars.get(2));
                        continue block6;
                    }
                    default: {
                        sb.append((String)maskingChars.get(3));
                    }
                }
            }
            return sb.toString();
        };
    }

    private JsonNode maskWithFieldsCheck(JsonNode node) {
        if (node.isObject()) {
            ObjectNode obj = ((ObjectNode)node).objectNode();
            node.fields().forEachRemaining(f -> {
                String fieldName = (String)f.getKey();
                JsonNode fieldVal = (JsonNode)f.getValue();
                if (this.fieldShouldBeMasked(fieldName)) {
                    obj.set(fieldName, this.maskNodeRecursively(fieldVal));
                } else {
                    obj.set(fieldName, this.maskWithFieldsCheck(fieldVal));
                }
            });
            return obj;
        }
        if (node.isArray()) {
            ArrayNode arr = ((ArrayNode)node).arrayNode(node.size());
            node.elements().forEachRemaining(e -> arr.add(this.maskWithFieldsCheck(e)));
            return arr;
        }
        return node;
    }

    private JsonNode maskNodeRecursively(JsonNode node) {
        if (node.isObject()) {
            ObjectNode obj = ((ObjectNode)node).objectNode();
            node.fields().forEachRemaining(f -> obj.set((String)f.getKey(), this.maskNodeRecursively((JsonNode)f.getValue())));
            return obj;
        }
        if (node.isArray()) {
            ArrayNode arr = ((ArrayNode)node).arrayNode(node.size());
            node.elements().forEachRemaining(e -> arr.add(this.maskNodeRecursively(e)));
            return arr;
        }
        return new TextNode((String)this.masker.apply(node.asText()));
    }
}

