/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.masking.policies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.provectus.kafka.ui.service.masking.policies.FieldsSelector;
import com.provectus.kafka.ui.service.masking.policies.MaskingPolicy;

class Remove
extends MaskingPolicy {
    Remove(FieldsSelector fieldsSelector) {
        super(fieldsSelector);
    }

    public String applyToString(String str) {
        return "null";
    }

    public ContainerNode<?> applyToJsonContainer(ContainerNode<?> node) {
        return (ContainerNode)this.removeFields(node);
    }

    private JsonNode removeFields(JsonNode node) {
        if (node.isObject()) {
            ObjectNode obj = ((ObjectNode)node).objectNode();
            node.fields().forEachRemaining(f -> {
                String fieldName = (String)f.getKey();
                JsonNode fieldVal = (JsonNode)f.getValue();
                if (!this.fieldShouldBeMasked(fieldName)) {
                    obj.set(fieldName, this.removeFields(fieldVal));
                }
            });
            return obj;
        }
        if (node.isArray()) {
            ArrayNode arr = ((ArrayNode)node).arrayNode(node.size());
            node.elements().forEachRemaining(e -> arr.add(this.removeFields(e)));
            return arr;
        }
        return node;
    }
}

