/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.metrics;

import com.google.common.base.Preconditions;
import com.provectus.kafka.ui.service.metrics.JmxSslSocketFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

class JmxSslSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(JmxSslSocketFactory.class);
    private static final boolean SSL_JMX_SUPPORTED;
    private static final ThreadLocal<Ssl> SSL_CONTEXT_THREAD_LOCAL;
    private static final Map<HostAndPort, SSLSocketFactory> CACHED_FACTORIES;
    private final SSLSocketFactory defaultSocketFactory = SSLContext.getDefault().getSocketFactory();

    public static boolean initialized() {
        return SSL_JMX_SUPPORTED;
    }

    public static void setSslContextThreadLocal(@Nullable String truststoreLocation, @Nullable String truststorePassword, @Nullable String keystoreLocation, @Nullable String keystorePassword) {
        SSL_CONTEXT_THREAD_LOCAL.set(new Ssl(truststoreLocation, truststorePassword, keystoreLocation, keystorePassword));
    }

    public static void clearFactoriesCache() {
        CACHED_FACTORIES.clear();
    }

    public static void clearThreadLocalContext() {
        SSL_CONTEXT_THREAD_LOCAL.set(null);
    }

    public static void editJmxConnectorEnv(Map<String, Object> env) {
        env.put("com.sun.jndi.rmi.factory.socket", new SslRMIClientSocketFactory());
    }

    private SSLSocketFactory createFactoryFromThreadLocalCtx() {
        Ssl ssl = (Ssl)Preconditions.checkNotNull((Object)((Ssl)SSL_CONTEXT_THREAD_LOCAL.get()));
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        if (ssl.truststoreLocation() != null && ssl.truststorePassword() != null) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(new FileInputStream(ResourceUtils.getFile((String)ssl.truststoreLocation())), ssl.truststorePassword().toCharArray());
            trustManagerFactory.init(trustStore);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (ssl.keystoreLocation() != null && ssl.keystorePassword() != null) {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(new FileInputStream(ResourceUtils.getFile((String)ssl.keystoreLocation())), ssl.keystorePassword().toCharArray());
            keyManagerFactory.init(keyStore, ssl.keystorePassword().toCharArray());
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return ctx.getSocketFactory();
    }

    private boolean threadLocalContextSet() {
        return SSL_CONTEXT_THREAD_LOCAL.get() != null;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        HostAndPort hostAndPort = new HostAndPort(host, port);
        if (CACHED_FACTORIES.containsKey(hostAndPort)) {
            return ((SSLSocketFactory)CACHED_FACTORIES.get(hostAndPort)).createSocket(host, port);
        }
        if (this.threadLocalContextSet()) {
            SSLSocketFactory factory = this.createFactoryFromThreadLocalCtx();
            CACHED_FACTORIES.put(hostAndPort, factory);
            return factory.createSocket(host, port);
        }
        return this.defaultSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        if (this.threadLocalContextSet()) {
            return this.createFactoryFromThreadLocalCtx().createSocket(s, host, port, autoClose);
        }
        return this.defaultSocketFactory.createSocket(s, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        if (this.threadLocalContextSet()) {
            return this.createFactoryFromThreadLocalCtx().createSocket(host, port, localHost, localPort);
        }
        return this.defaultSocketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        if (this.threadLocalContextSet()) {
            return this.createFactoryFromThreadLocalCtx().createSocket(host, port);
        }
        return this.defaultSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.threadLocalContextSet()) {
            return this.createFactoryFromThreadLocalCtx().createSocket(address, port, localAddress, localPort);
        }
        return this.defaultSocketFactory.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        if (this.threadLocalContextSet()) {
            return this.createFactoryFromThreadLocalCtx().getDefaultCipherSuites();
        }
        return this.defaultSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        if (this.threadLocalContextSet()) {
            return this.createFactoryFromThreadLocalCtx().getSupportedCipherSuites();
        }
        return this.defaultSocketFactory.getSupportedCipherSuites();
    }

    static {
        boolean sslJmxSupported = false;
        try {
            Field defaultSocketFactoryField = SslRMIClientSocketFactory.class.getDeclaredField("defaultSocketFactory");
            defaultSocketFactoryField.setAccessible(true);
            defaultSocketFactoryField.set(null, new JmxSslSocketFactory());
            sslJmxSupported = true;
        }
        catch (Exception e) {
            log.error("----------------------------------");
            log.error("SSL can't be enabled for JMX retrieval. Make sure your java app run with '--add-opens java.rmi/javax.rmi.ssl=ALL-UNNAMED' arg. Err: {}", (Object)e.getMessage());
            log.trace("SSL can't be enabled for JMX retrieval", (Throwable)e);
            log.error("----------------------------------");
        }
        SSL_JMX_SUPPORTED = sslJmxSupported;
        SSL_CONTEXT_THREAD_LOCAL = new ThreadLocal();
        CACHED_FACTORIES = new ConcurrentHashMap();
    }
}

