/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.metrics;

import com.provectus.kafka.ui.model.KafkaCluster;
import com.provectus.kafka.ui.model.Metrics;
import com.provectus.kafka.ui.service.metrics.JmxMetricsRetriever;
import com.provectus.kafka.ui.service.metrics.PrometheusMetricsRetriever;
import com.provectus.kafka.ui.service.metrics.RawMetric;
import com.provectus.kafka.ui.service.metrics.WellKnownMetrics;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Component
public class MetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(MetricsCollector.class);
    private final JmxMetricsRetriever jmxMetricsRetriever;
    private final PrometheusMetricsRetriever prometheusMetricsRetriever;

    public Mono<Metrics> getBrokerMetrics(KafkaCluster cluster, Collection<Node> nodes) {
        return Flux.fromIterable(nodes).flatMap(n -> this.getMetrics(cluster, n).map(lst -> Tuples.of((Object)n, (Object)lst))).collectMap(Tuple2::getT1, Tuple2::getT2).map(nodeMetrics -> this.collectMetrics(cluster, nodeMetrics)).defaultIfEmpty((Object)Metrics.empty());
    }

    private Mono<List<RawMetric>> getMetrics(KafkaCluster kafkaCluster, Node node) {
        Flux metricFlux = Flux.empty();
        if (kafkaCluster.getMetricsConfig() != null) {
            String type = kafkaCluster.getMetricsConfig().getType();
            if (type == null || type.equalsIgnoreCase("JMX")) {
                metricFlux = this.jmxMetricsRetriever.retrieve(kafkaCluster, node);
            } else if (type.equalsIgnoreCase("PROMETHEUS")) {
                metricFlux = this.prometheusMetricsRetriever.retrieve(kafkaCluster, node);
            }
        }
        return metricFlux.collectList();
    }

    public Metrics collectMetrics(KafkaCluster cluster, Map<Node, List<RawMetric>> perBrokerMetrics) {
        Metrics.MetricsBuilder builder = Metrics.builder().perBrokerMetrics(perBrokerMetrics.entrySet().stream().collect(Collectors.toMap(e -> ((Node)e.getKey()).id(), Map.Entry::getValue)));
        this.populateWellknowMetrics(cluster, perBrokerMetrics).apply(builder);
        return builder.build();
    }

    private WellKnownMetrics populateWellknowMetrics(KafkaCluster cluster, Map<Node, List<RawMetric>> perBrokerMetrics) {
        WellKnownMetrics wellKnownMetrics = new WellKnownMetrics();
        perBrokerMetrics.forEach((node, metrics) -> metrics.forEach(metric -> wellKnownMetrics.populate(node, metric)));
        return wellKnownMetrics;
    }

    public MetricsCollector(JmxMetricsRetriever jmxMetricsRetriever, PrometheusMetricsRetriever prometheusMetricsRetriever) {
        this.jmxMetricsRetriever = jmxMetricsRetriever;
        this.prometheusMetricsRetriever = prometheusMetricsRetriever;
    }
}

