/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.metrics;

import com.provectus.kafka.ui.model.Metrics;
import com.provectus.kafka.ui.service.metrics.RawMetric;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.Node;

class WellKnownMetrics {
    private static final String BROKER_TOPIC_METRICS = "BrokerTopicMetrics";
    private static final String FIFTEEN_MINUTE_RATE = "FifteenMinuteRate";
    final Map<Integer, BigDecimal> brokerBytesInFifteenMinuteRate = new HashMap();
    final Map<Integer, BigDecimal> brokerBytesOutFifteenMinuteRate = new HashMap();
    final Map<String, BigDecimal> bytesInFifteenMinuteRate = new HashMap();
    final Map<String, BigDecimal> bytesOutFifteenMinuteRate = new HashMap();

    WellKnownMetrics() {
    }

    void populate(Node node, RawMetric rawMetric) {
        this.updateBrokerIOrates(node, rawMetric);
        this.updateTopicsIOrates(rawMetric);
    }

    void apply(Metrics.MetricsBuilder metricsBuilder) {
        metricsBuilder.topicBytesInPerSec(this.bytesInFifteenMinuteRate);
        metricsBuilder.topicBytesOutPerSec(this.bytesOutFifteenMinuteRate);
        metricsBuilder.brokerBytesInPerSec(this.brokerBytesInFifteenMinuteRate);
        metricsBuilder.brokerBytesOutPerSec(this.brokerBytesOutFifteenMinuteRate);
    }

    private void updateBrokerIOrates(Node node, RawMetric rawMetric) {
        String name = rawMetric.name();
        if (!this.brokerBytesInFifteenMinuteRate.containsKey(node.id()) && rawMetric.labels().size() == 1 && "BytesInPerSec".equalsIgnoreCase((String)rawMetric.labels().get("name")) && StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)BROKER_TOPIC_METRICS) && StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)FIFTEEN_MINUTE_RATE)) {
            this.brokerBytesInFifteenMinuteRate.put(node.id(), rawMetric.value());
        }
        if (!this.brokerBytesOutFifteenMinuteRate.containsKey(node.id()) && rawMetric.labels().size() == 1 && "BytesOutPerSec".equalsIgnoreCase((String)rawMetric.labels().get("name")) && StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)BROKER_TOPIC_METRICS) && StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)FIFTEEN_MINUTE_RATE)) {
            this.brokerBytesOutFifteenMinuteRate.put(node.id(), rawMetric.value());
        }
    }

    private void updateTopicsIOrates(RawMetric rawMetric) {
        String name = rawMetric.name();
        String topic = (String)rawMetric.labels().get("topic");
        if (topic != null && StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)BROKER_TOPIC_METRICS) && StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)FIFTEEN_MINUTE_RATE)) {
            String nameProperty = (String)rawMetric.labels().get("name");
            if ("BytesInPerSec".equalsIgnoreCase(nameProperty)) {
                this.bytesInFifteenMinuteRate.compute(topic, (k, v) -> v == null ? rawMetric.value() : v.add(rawMetric.value()));
            } else if ("BytesOutPerSec".equalsIgnoreCase(nameProperty)) {
                this.bytesOutFifteenMinuteRate.compute(topic, (k, v) -> v == null ? rawMetric.value() : v.add(rawMetric.value()));
            }
        }
    }
}

