/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.rbac.extractor;

import com.provectus.kafka.ui.model.rbac.Role;
import com.provectus.kafka.ui.model.rbac.provider.Provider;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.ProviderAuthorityExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class GithubAuthorityExtractor
implements ProviderAuthorityExtractor {
    private static final Logger log = LoggerFactory.getLogger(GithubAuthorityExtractor.class);
    private static final String ORGANIZATION_ATTRIBUTE_NAME = "organizations_url";
    private static final String USERNAME_ATTRIBUTE_NAME = "login";
    private static final String ORGANIZATION_NAME = "login";
    private static final String ORGANIZATION = "organization";
    private static final String TEAM_NAME = "slug";
    private static final String GITHUB_ACCEPT_HEADER = "application/vnd.github+json";
    private static final String DUMMY = "dummy";
    private static final Integer ORGANIZATIONS_PER_PAGE = 100;

    public boolean isApplicable(String provider, Map<String, String> customParams) {
        return Provider.Name.GITHUB.equalsIgnoreCase(provider) || Provider.Name.GITHUB.equalsIgnoreCase(customParams.get("type"));
    }

    public Mono<Set<String>> extract(AccessControlService acs, Object value, Map<String, Object> additionalParams) {
        DefaultOAuth2User principal;
        try {
            principal = (DefaultOAuth2User)value;
        }
        catch (ClassCastException e) {
            log.error("Can't cast value to DefaultOAuth2User", (Throwable)e);
            throw new RuntimeException();
        }
        HashSet rolesByUsername = new HashSet();
        String username = (String)principal.getAttribute("login");
        if (username == null) {
            log.debug("Github username param is not present");
        } else {
            acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_GITHUB)).filter(s -> s.getType().equals("user")).anyMatch(s -> s.getValue().equals(username))).map(Role::getName).forEach(rolesByUsername::add);
        }
        OAuth2UserRequest req = (OAuth2UserRequest)additionalParams.get("request");
        String infoEndpoint = req.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUri();
        if (infoEndpoint == null) {
            infoEndpoint = CommonOAuth2Provider.GITHUB.getBuilder(DUMMY).clientId(DUMMY).build().getProviderDetails().getUserInfoEndpoint().getUri();
        }
        WebClient webClient = WebClient.create((String)infoEndpoint);
        Mono rolesByOrganization = this.getOrganizationRoles(principal, additionalParams, acs, webClient);
        Mono rolesByTeams = this.getTeamRoles(webClient, additionalParams, acs);
        return Mono.zip((Mono)rolesByOrganization, (Mono)rolesByTeams).map(t -> Stream.of((Set)t.getT1(), (Set)t.getT2(), rolesByUsername).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    private Mono<Set<String>> getOrganizationRoles(DefaultOAuth2User principal, Map<String, Object> additionalParams, AccessControlService acs, WebClient webClient) {
        String organization = (String)principal.getAttribute(ORGANIZATION_ATTRIBUTE_NAME);
        if (organization == null) {
            log.debug("Github organization param is not present");
            return Mono.just(Collections.emptySet());
        }
        Mono userOrganizations = webClient.get().uri(uriBuilder -> uriBuilder.path("/orgs").queryParam("per_page", new Object[]{ORGANIZATIONS_PER_PAGE}).build(new Object[0])).headers(headers -> {
            headers.set("Accept", GITHUB_ACCEPT_HEADER);
            OAuth2UserRequest request = (OAuth2UserRequest)additionalParams.get("request");
            headers.setBearerAuth(request.getAccessToken().getTokenValue());
        }).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return userOrganizations.map(orgsMap -> acs.getRoles().stream().filter(role -> role.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_GITHUB)).filter(s -> s.getType().equals(ORGANIZATION)).anyMatch(subject -> orgsMap.stream().map(org -> org.get("login").toString()).anyMatch(orgName -> orgName.equalsIgnoreCase(subject.getValue())))).map(Role::getName).collect(Collectors.toSet()));
    }

    private Mono<Set<String>> getTeamRoles(WebClient webClient, Map<String, Object> additionalParams, AccessControlService acs) {
        Set requestedTeams = acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_GITHUB)).anyMatch(s -> s.getType().equals("team"))).collect(Collectors.toSet());
        if (requestedTeams.isEmpty()) {
            log.debug("No roles with github teams found, skipping");
            return Mono.just(Collections.emptySet());
        }
        Mono rawTeams = webClient.get().uri(uriBuilder -> uriBuilder.path("/teams").queryParam("per_page", new Object[]{ORGANIZATIONS_PER_PAGE}).build(new Object[0])).headers(headers -> {
            headers.set("Accept", GITHUB_ACCEPT_HEADER);
            OAuth2UserRequest request = (OAuth2UserRequest)additionalParams.get("request");
            headers.setBearerAuth(request.getAccessToken().getTokenValue());
        }).retrieve().bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Mono mappedTeams = rawTeams.map(teams -> teams.stream().map(teamInfo -> {
            Object name = teamInfo.get(TEAM_NAME);
            Map orgInfo = (Map)teamInfo.get(ORGANIZATION);
            Object orgName = orgInfo.get("login");
            return orgName + "/" + name;
        }).map(Object::toString).collect(Collectors.toList()));
        return mappedTeams.map(teams -> acs.getRoles().stream().filter(role -> role.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_GITHUB)).filter(s -> s.getType().equals("team")).anyMatch(subject -> teams.stream().anyMatch(teamName -> teamName.equalsIgnoreCase(subject.getValue())))).map(Role::getName).collect(Collectors.toSet()));
    }
}

