/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.service.rbac.extractor;

import com.google.common.collect.Sets;
import com.provectus.kafka.ui.model.rbac.Role;
import com.provectus.kafka.ui.model.rbac.provider.Provider;
import com.provectus.kafka.ui.service.rbac.AccessControlService;
import com.provectus.kafka.ui.service.rbac.extractor.ProviderAuthorityExtractor;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import reactor.core.publisher.Mono;

public class GoogleAuthorityExtractor
implements ProviderAuthorityExtractor {
    private static final Logger log = LoggerFactory.getLogger(GoogleAuthorityExtractor.class);
    private static final String GOOGLE_DOMAIN_ATTRIBUTE_NAME = "hd";
    public static final String EMAIL_ATTRIBUTE_NAME = "email";

    public boolean isApplicable(String provider, Map<String, String> customParams) {
        return Provider.Name.GOOGLE.equalsIgnoreCase(provider) || Provider.Name.GOOGLE.equalsIgnoreCase(customParams.get("type"));
    }

    public Mono<Set<String>> extract(AccessControlService acs, Object value, Map<String, Object> additionalParams) {
        DefaultOAuth2User principal;
        log.debug("Extracting google user authorities");
        try {
            principal = (DefaultOAuth2User)value;
        }
        catch (ClassCastException e) {
            log.error("Can't cast value to DefaultOAuth2User", (Throwable)e);
            throw new RuntimeException();
        }
        Set groupsByUsername = acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_GOOGLE)).filter(s -> s.getType().equals("user")).anyMatch(s -> s.getValue().equals(principal.getAttribute(EMAIL_ATTRIBUTE_NAME)))).map(Role::getName).collect(Collectors.toSet());
        String domain = (String)principal.getAttribute(GOOGLE_DOMAIN_ATTRIBUTE_NAME);
        if (domain == null) {
            log.debug("Google domain param is not present");
            return Mono.just(groupsByUsername);
        }
        Set groupsByDomain = acs.getRoles().stream().filter(r -> r.getSubjects().stream().filter(s -> s.getProvider().equals((Object)Provider.OAUTH_GOOGLE)).filter(s -> s.getType().equals("domain")).anyMatch(s -> s.getValue().equals(domain))).map(Role::getName).collect(Collectors.toSet());
        return Mono.just((Object)Sets.union(groupsByUsername, groupsByDomain));
    }
}

