/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util;

import com.provectus.kafka.ui.KafkaUiApplication;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ApplicationRestarter
implements ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRestarter.class);
    private String[] applicationArgs;
    private ApplicationContext applicationContext;

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.applicationArgs = event.getArgs();
        this.applicationContext = event.getApplicationContext();
    }

    public void requestRestart() {
        log.info("Restarting application");
        Thread thread = new Thread(() -> {
            this.closeApplicationContext(this.applicationContext);
            KafkaUiApplication.startApplication((String[])this.applicationArgs);
        });
        thread.setName("restartedMain-" + System.currentTimeMillis());
        thread.setDaemon(false);
        thread.start();
    }

    private void closeApplicationContext(ApplicationContext context) {
        while (context instanceof Closeable) {
            try {
                ((Closeable)context).close();
            }
            catch (Exception e) {
                log.warn("Error stopping application before restart", (Throwable)e);
                throw new RuntimeException(e);
            }
            context = context.getParent();
        }
    }
}

