/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util;

import java.net.URI;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class EmptyRedirectStrategy
implements ServerRedirectStrategy {
    private HttpStatus httpStatus = HttpStatus.FOUND;
    private boolean contextRelative = true;

    public Mono<Void> sendRedirect(ServerWebExchange exchange, URI location) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        Assert.notNull((Object)location, (String)"location cannot be null");
        return Mono.fromRunnable(() -> {
            ServerHttpResponse response = exchange.getResponse();
            response.setStatusCode((HttpStatusCode)this.httpStatus);
            response.getHeaders().setLocation(this.createLocation(exchange, location));
        });
    }

    private URI createLocation(ServerWebExchange exchange, URI location) {
        String url;
        if (!this.contextRelative) {
            return location;
        }
        String string = url = location.getPath().isEmpty() ? "/" : location.toASCIIString();
        if (url.startsWith("/")) {
            String context = exchange.getRequest().getPath().contextPath().value();
            return URI.create(context + url);
        }
        return location;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        Assert.notNull((Object)httpStatus, (String)"httpStatus cannot be null");
        this.httpStatus = httpStatus;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }
}

