/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util.jsonschema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.provectus.kafka.ui.exception.JsonAvroConversionException;
import com.provectus.kafka.ui.util.jsonschema.JsonAvroConversion;
import io.confluent.kafka.serializers.AvroData;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonAvroConversion {
    private static final JsonMapper MAPPER = new JsonMapper();
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final String FORMAT = "format";
    private static final String DATE_TIME = "date-time";

    public static Object convertJsonToAvro(String jsonString, Schema avroSchema) {
        JsonNode rootNode = null;
        try {
            rootNode = MAPPER.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new JsonAvroConversionException("String is not a valid json");
        }
        return JsonAvroConversion.convert((JsonNode)rootNode, (Schema)avroSchema);
    }

    private static Object convert(JsonNode node, Schema avroSchema) {
        return switch (1.$SwitchMap$org$apache$avro$Schema$Type[avroSchema.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.OBJECT});
                GenericData.Record rec = new GenericData.Record(avroSchema);
                for (Schema.Field field : avroSchema.getFields()) {
                    if (!node.has(field.name()) || node.get(field.name()).isNull()) continue;
                    rec.put(field.name(), JsonAvroConversion.convert((JsonNode)node.get(field.name()), (Schema)field.schema()));
                }
                yield rec;
            }
            case 2 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.OBJECT});
                LinkedHashMap map = new LinkedHashMap();
                Schema valueSchema = avroSchema.getValueType();
                node.fields().forEachRemaining(f -> map.put((String)f.getKey(), JsonAvroConversion.convert((JsonNode)((JsonNode)f.getValue()), (Schema)valueSchema)));
                yield map;
            }
            case 3 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.ARRAY});
                GenericData.Record lst = new ArrayList();
                node.elements().forEachRemaining(e -> lst.add(JsonAvroConversion.convert((JsonNode)e, (Schema)avroSchema.getElementType())));
                yield lst;
            }
            case 4 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
                String symbol = node.textValue();
                if (!avroSchema.getEnumSymbols().contains(symbol)) {
                    throw new JsonAvroConversionException("%s is not a part of enum symbols [%s]".formatted(symbol, avroSchema.getEnumSymbols()));
                }
                yield new GenericData.EnumSymbol(avroSchema, symbol);
            }
            case 5 -> {
                if (node.isNull() && avroSchema.getTypes().contains(NULL_SCHEMA)) {
                    yield null;
                }
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.OBJECT});
                ArrayList elements = Lists.newArrayList((Iterator)node.fields());
                if (elements.size() != 1) {
                    throw new JsonAvroConversionException("UNION field value should be an object with single field == type name");
                }
                Map.Entry typeNameToValue = (Map.Entry)elements.get(0);
                ArrayList<Schema> candidates = new ArrayList<Schema>();
                for (Schema unionType : avroSchema.getTypes()) {
                    if (((String)typeNameToValue.getKey()).equals(unionType.getFullName())) {
                        yield JsonAvroConversion.convert((JsonNode)((JsonNode)typeNameToValue.getValue()), (Schema)unionType);
                    }
                    if (!((String)typeNameToValue.getKey()).equals(unionType.getName())) continue;
                    candidates.add(unionType);
                }
                if (candidates.size() == 1) {
                    yield JsonAvroConversion.convert((JsonNode)((JsonNode)typeNameToValue.getValue()), (Schema)((Schema)candidates.get(0)));
                }
                if (candidates.size() > 1) {
                    throw new JsonAvroConversionException("Can't select type within union for value '%s'. Provide full type name.".formatted(node));
                }
                throw new JsonAvroConversionException("json value '%s' is cannot be converted to any of union types [%s]".formatted(node, avroSchema.getTypes()));
            }
            case 6 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((JsonNode)node, (Schema)avroSchema);
                }
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
                yield node.textValue();
            }
            case 7 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((JsonNode)node, (Schema)avroSchema);
                }
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.NUMBER});
                JsonAvroConversion.assertJsonNumberType((JsonNode)node, (JsonParser.NumberType[])new JsonParser.NumberType[]{JsonParser.NumberType.LONG, JsonParser.NumberType.INT});
                yield Long.valueOf(node.longValue());
            }
            case 8 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((JsonNode)node, (Schema)avroSchema);
                }
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.NUMBER});
                JsonAvroConversion.assertJsonNumberType((JsonNode)node, (JsonParser.NumberType[])new JsonParser.NumberType[]{JsonParser.NumberType.INT});
                yield Integer.valueOf(node.intValue());
            }
            case 9 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.NUMBER});
                JsonAvroConversion.assertJsonNumberType((JsonNode)node, (JsonParser.NumberType[])new JsonParser.NumberType[]{JsonParser.NumberType.DOUBLE, JsonParser.NumberType.FLOAT});
                yield Float.valueOf(node.floatValue());
            }
            case 10 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.NUMBER});
                JsonAvroConversion.assertJsonNumberType((JsonNode)node, (JsonParser.NumberType[])new JsonParser.NumberType[]{JsonParser.NumberType.DOUBLE, JsonParser.NumberType.FLOAT});
                yield Double.valueOf(node.doubleValue());
            }
            case 11 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.BOOLEAN});
                yield Boolean.valueOf(node.booleanValue());
            }
            case 12 -> {
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.NULL});
                yield null;
            }
            case 13 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((JsonNode)node, (Schema)avroSchema);
                }
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
                yield ByteBuffer.wrap(node.textValue().getBytes(StandardCharsets.ISO_8859_1));
            }
            case 14 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((JsonNode)node, (Schema)avroSchema);
                }
                JsonAvroConversion.assertJsonType((JsonNode)node, (JsonNodeType[])new JsonNodeType[]{JsonNodeType.STRING});
                byte[] bytes = node.textValue().getBytes(StandardCharsets.ISO_8859_1);
                if (bytes.length != avroSchema.getFixedSize()) {
                    throw new JsonAvroConversionException("Fixed field has unexpected size %d (should be %d)".formatted(bytes.length, avroSchema.getFixedSize()));
                }
                yield new GenericData.Fixed(avroSchema, bytes);
            }
        };
    }

    public static JsonNode convertAvroToJson(Object obj, Schema avroSchema) {
        if (obj == null) {
            return NullNode.getInstance();
        }
        return switch (1.$SwitchMap$org$apache$avro$Schema$Type[avroSchema.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                GenericData.Record rec = (GenericData.Record)obj;
                ObjectNode node = MAPPER.createObjectNode();
                for (Schema.Field field : avroSchema.getFields()) {
                    Object fieldVal = rec.get(field.name());
                    if (fieldVal == null) continue;
                    node.set(field.name(), JsonAvroConversion.convertAvroToJson((Object)fieldVal, (Schema)field.schema()));
                }
                yield node;
            }
            case 2 -> {
                ObjectNode node = MAPPER.createObjectNode();
                ((Map)obj).forEach((k, v) -> node.set(k.toString(), JsonAvroConversion.convertAvroToJson((Object)v, (Schema)avroSchema.getValueType())));
                yield node;
            }
            case 3 -> {
                List list = (List)obj;
                ArrayNode node = MAPPER.createArrayNode();
                list.forEach(e -> node.add(JsonAvroConversion.convertAvroToJson((Object)e, (Schema)avroSchema.getElementType())));
                yield node;
            }
            case 4 -> new TextNode(obj.toString());
            case 5 -> {
                ObjectNode node = MAPPER.createObjectNode();
                int unionIdx = AvroData.getGenericData().resolveUnion(avroSchema, obj);
                Schema selectedType = (Schema)avroSchema.getTypes().get(unionIdx);
                node.set(JsonAvroConversion.selectUnionTypeFieldName((Schema)avroSchema, (Schema)selectedType, (int)unionIdx), JsonAvroConversion.convertAvroToJson((Object)obj, (Schema)selectedType));
                yield node;
            }
            case 6 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((Object)obj, (Schema)avroSchema);
                }
                yield new TextNode(obj.toString());
            }
            case 7 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((Object)obj, (Schema)avroSchema);
                }
                yield new LongNode(((Long)obj).longValue());
            }
            case 8 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((Object)obj, (Schema)avroSchema);
                }
                yield new IntNode(((Integer)obj).intValue());
            }
            case 9 -> new FloatNode(((Float)obj).floatValue());
            case 10 -> new DoubleNode(((Double)obj).doubleValue());
            case 11 -> BooleanNode.valueOf((boolean)((Boolean)obj));
            case 12 -> NullNode.getInstance();
            case 13 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((Object)obj, (Schema)avroSchema);
                }
                ByteBuffer bytes = (ByteBuffer)obj;
                yield new TextNode(new String(bytes.array(), StandardCharsets.ISO_8859_1));
            }
            case 14 -> {
                if (JsonAvroConversion.isLogicalType((Schema)avroSchema)) {
                    yield JsonAvroConversion.processLogicalType((Object)obj, (Schema)avroSchema);
                }
                GenericData.Fixed fixed = (GenericData.Fixed)obj;
                yield new TextNode(new String(fixed.bytes(), StandardCharsets.ISO_8859_1));
            }
        };
    }

    private static String selectUnionTypeFieldName(Schema unionSchema, Schema chosenType, int chosenTypeIdx) {
        List types = unionSchema.getTypes();
        if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
            return chosenType.getName();
        }
        for (int i = 0; i < types.size(); ++i) {
            if (i == chosenTypeIdx || !chosenType.getName().equals(((Schema)types.get(i)).getName())) continue;
            return chosenType.getFullName();
        }
        return chosenType.getName();
    }

    private static Object processLogicalType(JsonNode node, Schema schema) {
        return JsonAvroConversion.findConversion((Schema)schema).map(c -> c.jsonToAvroConversion.apply(node, schema)).orElseThrow(() -> new JsonAvroConversionException("'%s' logical type is not supported".formatted(schema.getLogicalType().getName())));
    }

    private static JsonNode processLogicalType(Object obj, Schema schema) {
        return JsonAvroConversion.findConversion((Schema)schema).map(c -> (JsonNode)c.avroToJsonConversion.apply(obj, schema)).orElseThrow(() -> new JsonAvroConversionException("'%s' logical type is not supported".formatted(schema.getLogicalType().getName())));
    }

    private static Optional<LogicalTypeConversion> findConversion(Schema schema) {
        String logicalTypeName = schema.getLogicalType().getName();
        return Stream.of(LogicalTypeConversion.values()).filter(t -> t.name.equalsIgnoreCase(logicalTypeName)).findFirst();
    }

    private static boolean isLogicalType(Schema schema) {
        return schema.getLogicalType() != null;
    }

    private static void assertJsonType(JsonNode node, JsonNodeType ... allowedTypes) {
        if (Stream.of(allowedTypes).noneMatch(t -> node.getNodeType() == t)) {
            throw new JsonAvroConversionException("%s node has unexpected type, allowed types %s, actual type %s".formatted(node, Arrays.toString(allowedTypes), node.getNodeType()));
        }
    }

    private static void assertJsonNumberType(JsonNode node, JsonParser.NumberType ... allowedTypes) {
        if (Stream.of(allowedTypes).noneMatch(t -> node.numberType() == t)) {
            throw new JsonAvroConversionException("%s node has unexpected numeric type, allowed types %s, actual type %s".formatted(node, Arrays.toString(allowedTypes), node.numberType()));
        }
    }
}

