/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.util.jsonschema;

import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.provectus.kafka.ui.util.jsonschema.AnyFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.ArrayFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.EnumJsonType;
import com.provectus.kafka.ui.util.jsonschema.FieldSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonSchema;
import com.provectus.kafka.ui.util.jsonschema.JsonSchemaConverter;
import com.provectus.kafka.ui.util.jsonschema.JsonType;
import com.provectus.kafka.ui.util.jsonschema.MapFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.ObjectFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.ProtobufSchemaConverter;
import com.provectus.kafka.ui.util.jsonschema.RefFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.SimpleFieldSchema;
import com.provectus.kafka.ui.util.jsonschema.SimpleJsonType;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ProtobufSchemaConverter
implements JsonSchemaConverter<Descriptors.Descriptor> {
    private static final String MAXIMUM = "maximum";
    private static final String MINIMUM = "minimum";
    private final Set<String> simpleTypesWrapperNames = Set.of(BoolValue.getDescriptor().getFullName(), Int32Value.getDescriptor().getFullName(), UInt32Value.getDescriptor().getFullName(), Int64Value.getDescriptor().getFullName(), UInt64Value.getDescriptor().getFullName(), StringValue.getDescriptor().getFullName(), BytesValue.getDescriptor().getFullName(), FloatValue.getDescriptor().getFullName(), DoubleValue.getDescriptor().getFullName());

    public JsonSchema convert(URI basePath, Descriptors.Descriptor schema) {
        HashMap definitions = new HashMap();
        RefFieldSchema rootRef = this.registerObjectAndReturnRef(schema, definitions);
        return JsonSchema.builder().id(basePath.resolve(schema.getFullName())).type((JsonType)new SimpleJsonType(JsonType.Type.OBJECT)).rootRef(rootRef.getRef()).definitions(definitions).build();
    }

    private RefFieldSchema registerObjectAndReturnRef(Descriptors.Descriptor schema, Map<String, FieldSchema> definitions) {
        String definition = schema.getFullName();
        if (definitions.containsKey(definition)) {
            return this.createRefField(definition);
        }
        definitions.put(definition, (FieldSchema)ObjectFieldSchema.EMPTY);
        Map<String, FieldSchema> fields = schema.getFields().stream().map(f -> Tuples.of((Object)f.getName(), (Object)this.convertField(f, definitions))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2));
        List required = schema.getFields().stream().filter(Descriptors.FieldDescriptor::isRequired).map(Descriptors.FieldDescriptor::getName).collect(Collectors.toList());
        definitions.put(definition, (FieldSchema)new ObjectFieldSchema(fields, required));
        return this.createRefField(definition);
    }

    private RefFieldSchema createRefField(String definition) {
        return new RefFieldSchema("#/definitions/%s".formatted(definition));
    }

    private FieldSchema convertField(Descriptors.FieldDescriptor field, Map<String, FieldSchema> definitions) {
        Optional wellKnownTypeSchema = this.convertProtoWellKnownTypes(field);
        if (wellKnownTypeSchema.isPresent()) {
            return (FieldSchema)wellKnownTypeSchema.get();
        }
        if (field.isMapField()) {
            return new MapFieldSchema();
        }
        JsonType jsonType = this.convertType(field);
        Object fieldSchema = jsonType.getType().equals((Object)JsonType.Type.OBJECT) ? this.registerObjectAndReturnRef(field.getMessageType(), definitions) : new SimpleFieldSchema(jsonType);
        if (field.isRepeated()) {
            return new ArrayFieldSchema((FieldSchema)fieldSchema);
        }
        return fieldSchema;
    }

    private Optional<FieldSchema> convertProtoWellKnownTypes(Descriptors.FieldDescriptor field) {
        if (field.getType() != Descriptors.FieldDescriptor.Type.MESSAGE) {
            return Optional.empty();
        }
        String typeName = field.getMessageType().getFullName();
        if (typeName.equals(Timestamp.getDescriptor().getFullName())) {
            return Optional.of(new SimpleFieldSchema((JsonType)new SimpleJsonType(JsonType.Type.STRING, Map.of("format", new TextNode("date-time")))));
        }
        if (typeName.equals(Duration.getDescriptor().getFullName())) {
            return Optional.of(new SimpleFieldSchema((JsonType)new SimpleJsonType(JsonType.Type.STRING)));
        }
        if (typeName.equals(FieldMask.getDescriptor().getFullName())) {
            return Optional.of(new SimpleFieldSchema((JsonType)new SimpleJsonType(JsonType.Type.STRING)));
        }
        if (typeName.equals(Any.getDescriptor().getFullName()) || typeName.equals(Struct.getDescriptor().getFullName())) {
            return Optional.of(ObjectFieldSchema.EMPTY);
        }
        if (typeName.equals(Value.getDescriptor().getFullName())) {
            return Optional.of(AnyFieldSchema.get());
        }
        if (typeName.equals(ListValue.getDescriptor().getFullName())) {
            return Optional.of(new ArrayFieldSchema((FieldSchema)AnyFieldSchema.get()));
        }
        if (this.simpleTypesWrapperNames.contains(typeName)) {
            return Optional.of(new SimpleFieldSchema(this.convertType(Objects.requireNonNull(field.getMessageType().findFieldByName("value")))));
        }
        return Optional.empty();
    }

    private JsonType convertType(Descriptors.FieldDescriptor field) {
        return switch (1.$SwitchMap$com$google$protobuf$Descriptors$FieldDescriptor$Type[field.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2, 3, 4 -> new SimpleJsonType(JsonType.Type.INTEGER, Map.of(MAXIMUM, IntNode.valueOf((int)Integer.MAX_VALUE), MINIMUM, IntNode.valueOf((int)Integer.MIN_VALUE)));
            case 5 -> new SimpleJsonType(JsonType.Type.INTEGER, Map.of(MAXIMUM, LongNode.valueOf((long)UnsignedInteger.MAX_VALUE.longValue()), MINIMUM, IntNode.valueOf((int)0)));
            case 6, 7, 8, 9 -> new SimpleJsonType(JsonType.Type.INTEGER, Map.of(MAXIMUM, LongNode.valueOf((long)Long.MAX_VALUE), MINIMUM, LongNode.valueOf((long)Long.MIN_VALUE)));
            case 10 -> new SimpleJsonType(JsonType.Type.INTEGER, Map.of(MAXIMUM, new BigIntegerNode(UnsignedLong.MAX_VALUE.bigIntegerValue()), MINIMUM, LongNode.valueOf((long)0L)));
            case 11, 12 -> new SimpleJsonType(JsonType.Type.OBJECT);
            case 13 -> new EnumJsonType(field.getEnumType().getValues().stream().map(Descriptors.EnumValueDescriptor::getName).collect(Collectors.toList()));
            case 14, 15 -> new SimpleJsonType(JsonType.Type.STRING);
            case 16, 17 -> new SimpleJsonType(JsonType.Type.NUMBER);
            case 18 -> new SimpleJsonType(JsonType.Type.BOOLEAN);
        };
    }
}

