/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctionsKt;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J&\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J8\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u00180\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0003J@\u0010\u001d\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u00180\u001ej\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u0018`\u001f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0003J:\u0010#\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u00180\u001ej\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u0018`\u001f2\b\b\u0002\u0010!\u001a\u00020\"H\u0007J0\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u000f0%2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010'\u001a\u00020\u0013H\u0007J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fJ\u0010\u0010+\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J8\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010/\u001a\u00020\u00132\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000fH\u0007J\"\u00101\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u00063"}, d2={"Lcom/unciv/logic/map/tile/TileStatFunctions;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "<init>", "(Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "riverTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "getRiverTerrain", "()Lcom/unciv/models/ruleset/tile/Terrain;", "riverTerrain$delegate", "Lkotlin/Lazy;", "getTileStats", "Lcom/unciv/models/stats/Stats;", "observingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "city", "Lcom/unciv/logic/city/City;", "getTileStatsBreakdown", "", "Lkotlin/Pair;", "", "missingFromMinimum", "current", "minimumStats", "getSingleTerrainStats", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "terrain", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "getTerrainStatsBreakdown", "getTilePercentageStats", "Ljava/util/EnumMap;", "Lcom/unciv/logic/map/tile/TileStatFunctions$TilePercentageCategory;", "uniqueCache", "getTileStartScore", "", "cityCenterMinStats", "getTileStartYield", "getStatDiffForImprovement", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "cityUniqueCache", "currentTileStats", "getExtraImprovementStats", "TilePercentageCategory", "core"})
@SourceDebugExtension(value={"SMAP\nTileStatFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileStatFunctions.kt\ncom/unciv/logic/map/tile/TileStatFunctions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,352:1\n1255#2,2:353\n1255#2,2:362\n1255#2,2:364\n1276#2,3:366\n774#3:355\n865#3,2:356\n1563#3:358\n1634#3,3:359\n*S KotlinDebug\n*F\n+ 1 TileStatFunctions.kt\ncom/unciv/logic/map/tile/TileStatFunctions\n*L\n66#1:353,2\n271#1:362,2\n275#1:364,2\n333#1:366,3\n141#1:355\n141#1:356,2\n141#1:358\n141#1:359,3\n*E\n"})
public final class TileStatFunctions {
    @NotNull
    private final Tile tile;
    @NotNull
    private final Lazy riverTerrain$delegate;

    public TileStatFunctions(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.tile = tile;
        this.riverTerrain$delegate = LazyKt.lazy(() -> TileStatFunctions.riverTerrain_delegate$lambda$0(this));
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    private final Terrain getRiverTerrain() {
        Lazy lazy = this.riverTerrain$delegate;
        return (Terrain)lazy.getValue();
    }

    @Readonly
    @NotNull
    public final Stats getTileStats(@Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        return this.getTileStats(this.tile.getCity(), observingCiv, localUniqueCache);
    }

    public static /* synthetic */ Stats getTileStats$default(TileStatFunctions tileStatFunctions, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStats(civilization, localUniqueCache);
    }

    @Readonly
    @NotNull
    public final Stats getTileStats(@Nullable City city, @Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        List<Pair<String, Stats>> statsBreakdown = this.getTileStatsBreakdown(city, observingCiv, localUniqueCache);
        String improvement = this.tile.getUnpillagedImprovement();
        RoadStatus road = this.tile.getUnpillagedRoad();
        EnumMap<TilePercentageCategory, Stats> percentageStats = this.getTilePercentageStats(observingCiv, city, localUniqueCache);
        for (Pair<String, Stats> pair : statsBreakdown) {
            String cause = pair.component1();
            Stats stats = pair.component2();
            String string = cause;
            TilePercentageCategory tileType = Intrinsics.areEqual(string, improvement) ? TilePercentageCategory.Improvement : (Intrinsics.areEqual(string, road.name()) ? TilePercentageCategory.Road : TilePercentageCategory.Terrain);
            Stats stats2 = percentageStats.get((Object)tileType);
            Intrinsics.checkNotNull(stats2);
            for (Stats.StatValuePair statValuePair : stats2) {
                Stat stat = statValuePair.component1();
                float value = statValuePair.component2();
                stats.set(stat, stats.get(stat) * FormattingExtensionsKt.toPercent(value));
            }
        }
        return TileStatFunctionsKt.toStats(statsBreakdown);
    }

    public static /* synthetic */ Stats getTileStats$default(TileStatFunctions tileStatFunctions, City city, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStats(city, civilization, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Pair<String, Stats>> getTileStatsBreakdown(@Nullable City city, @Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Stats minimumStats;
        Object unique;
        Stats roadStats;
        TileImprovement road;
        Stats stats;
        Stats improvementStats;
        TileImprovement improvement;
        Stats stats2;
        boolean otherYieldsIgnored;
        ArrayList<Pair<String, Stats>> listOfStats;
        GameContext gameContext;
        block20: {
            boolean bl;
            Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
            gameContext = new GameContext(observingCiv, city, null, this.tile, null, null, null, null, null, null, false, 2036, null);
            listOfStats = this.getTerrainStatsBreakdown(gameContext);
            Sequence<Terrain> $this$any$iv = this.tile.getAllTerrains();
            boolean $i$f$any = false;
            Iterator<Terrain> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Terrain element$iv;
                Terrain it2 = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it2.hasUnique(UniqueType.NullifyYields, gameContext)) continue;
                bl = true;
                break block20;
            }
            bl = otherYieldsIgnored = false;
        }
        if ((stats2 = (improvement = otherYieldsIgnored ? null : this.tile.getUnpillagedTileImprovement())) == null || (stats2 = ((NamedStats)stats2).cloneStats()) == null) {
            stats2 = improvementStats = Stats.Companion.getZERO();
        }
        if ((stats = (road = otherYieldsIgnored ? null : this.tile.getUnpillagedRoadImprovement())) == null || (stats = ((NamedStats)stats).cloneStats()) == null) {
            stats = roadStats = Stats.Companion.getZERO();
        }
        if (city != null) {
            Sequence<Unique> statsFromTilesUniques = SequencesKt.filter(localUniqueCache.forCityGetMatchingUniques(city, UniqueType.StatsFromTiles, gameContext), arg_0 -> TileStatFunctions.getTileStatsBreakdown$lambda$1(city, arg_0));
            Sequence<Unique> statsFromObjectsUniques = localUniqueCache.forCityGetMatchingUniques(city, UniqueType.StatsFromObject, gameContext);
            Sequence<Unique> statsFromTilesWithoutUniques = SequencesKt.filter(localUniqueCache.forCityGetMatchingUniques(city, UniqueType.StatsFromTilesWithout, gameContext), arg_0 -> TileStatFunctions.getTileStatsBreakdown$lambda$2(city, this, arg_0));
            Iterator<Unique> iterator3 = SequencesKt.plus(SequencesKt.plus(statsFromTilesUniques, statsFromObjectsUniques), statsFromTilesWithoutUniques).iterator();
            while (iterator3.hasNext()) {
                unique = iterator3.next();
                String tileType = ((Unique)unique).getParams().get(1);
                if (improvement != null && TileImprovement.matchesFilter$default(improvement, tileType, gameContext, false, 4, null)) {
                    improvementStats.add(((Unique)unique).getStats());
                    continue;
                }
                if (this.tile.matchesFilter(tileType, observingCiv)) {
                    listOfStats.add(TuplesKt.to('{' + ((Unique)unique).getSourceObjectName() + "} ({" + ((Unique)unique).getDisplayText() + "})", ((Unique)unique).getStats()));
                    continue;
                }
                if (road == null || !TileImprovement.matchesFilter$default(road, tileType, gameContext, false, 4, null)) continue;
                roadStats.add(((Unique)unique).getStats());
            }
        }
        if (this.tile.isAdjacentToRiver()) {
            if (this.getRiverTerrain() == null) {
                listOfStats.add(TuplesKt.to("River", new Stats(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null)));
            } else {
                Collection collection = listOfStats;
                Terrain terrain = this.getRiverTerrain();
                Intrinsics.checkNotNull(terrain);
                CollectionsKt.addAll(collection, (Iterable)this.getSingleTerrainStats(terrain, gameContext));
            }
        }
        Stats stats3 = minimumStats = this.tile.isCityCenter() ? Stats.Companion.getDefaultCityCenterMinimum() : Stats.Companion.getZERO();
        if (observingCiv != null) {
            Unique ensureMinUnique;
            TileResource resource = this.tile.getTileResource();
            if (observingCiv.canSeeResource(resource)) {
                listOfStats.add(TuplesKt.to(resource.getName(), resource));
            }
            if (improvement != null) {
                improvementStats.add(this.getExtraImprovementStats(improvement, observingCiv, city));
            }
            if (road != null) {
                roadStats.add(this.getExtraImprovementStats(road, observingCiv, city));
            }
            if (improvement != null && (ensureMinUnique = SequencesKt.firstOrNull(improvement.getMatchingUniques(UniqueType.EnsureMinimumStats, gameContext))) != null) {
                minimumStats = ensureMinUnique.getStats();
            }
        }
        if (road != null) {
            listOfStats.add(TuplesKt.to(road.getName(), roadStats));
        }
        if (improvement != null) {
            listOfStats.add(TuplesKt.to(improvement.getName(), improvementStats));
        }
        Stats statsFromMinimum = this.missingFromMinimum(TileStatFunctionsKt.toStats((List<? extends Pair<String, ? extends Stats>>)listOfStats), minimumStats);
        listOfStats.add(TuplesKt.to("Minimum", statsFromMinimum));
        if (observingCiv != null && !(TileStatFunctionsKt.toStats((List<? extends Pair<String, ? extends Stats>>)listOfStats).getGold() == 0.0f) && observingCiv.getGoldenAges().isGoldenAge()) {
            listOfStats.add(TuplesKt.to("Golden Age", new Stats(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null)));
        }
        Iterable $this$filter$iv = listOfStats;
        boolean $i$f$filter = false;
        unique = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!((Stats)it.getSecond()).isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getFirst(), ((Stats)it.getSecond()).clone()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getTileStatsBreakdown$default(TileStatFunctions tileStatFunctions, City city, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStatsBreakdown(city, civilization, localUniqueCache);
    }

    @Readonly
    private final Stats missingFromMinimum(Stats current, Stats minimumStats) {
        Stats missingStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        for (Stat stat : Stat.getEntries()) {
            if (!(current.get(stat) < minimumStats.get(stat))) continue;
            missingStats.set(stat, minimumStats.get(stat) - current.get(stat));
        }
        return missingStats;
    }

    @Readonly
    private final ArrayList<Pair<String, Stats>> getSingleTerrainStats(Terrain terrain, GameContext gameContext) {
        ArrayList<Pair<String, Stats>> list2 = new ArrayList<Pair<String, Stats>>();
        String string = terrain.getName();
        Intrinsics.checkNotNull(terrain, "null cannot be cast to non-null type com.unciv.models.stats.Stats");
        list2.add(TuplesKt.to(string, (Stats)terrain));
        Iterator<Unique> iterator2 = terrain.getMatchingUniques(UniqueType.Stats, gameContext).iterator();
        while (iterator2.hasNext()) {
            Unique unique = iterator2.next();
            list2.add(TuplesKt.to(terrain.getName() + ": " + unique.getDisplayText(), unique.getStats()));
        }
        return list2;
    }

    @Readonly
    @NotNull
    public final ArrayList<Pair<String, Stats>> getTerrainStatsBreakdown(@NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        ArrayList<Pair<String, Stats>> list2 = new ArrayList<Pair<String, Stats>>();
        Iterator<Terrain> iterator2 = this.tile.getAllTerrains().iterator();
        while (iterator2.hasNext()) {
            Terrain terrain;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            ArrayList<Pair<String, Stats>> terrainStats = this.getSingleTerrainStats(terrain, gameContext);
            if (terrain.hasUnique(UniqueType.NullifyYields, gameContext)) {
                return terrainStats;
            }
            if (terrain.getOverrideStats()) {
                list2 = terrainStats;
                continue;
            }
            CollectionsKt.addAll((Collection)list2, (Iterable)terrainStats);
        }
        return list2;
    }

    public static /* synthetic */ ArrayList getTerrainStatsBreakdown$default(TileStatFunctions tileStatFunctions, GameContext gameContext, int n, Object object) {
        if ((n & 1) != 0) {
            gameContext = new GameContext(null, null, null, null, null, null, null, null, null, null, false, 2047, null);
        }
        return tileStatFunctions.getTerrainStatsBreakdown(gameContext);
    }

    @Readonly
    @NotNull
    public final EnumMap<TilePercentageCategory, Stats> getTilePercentageStats(@Nullable Civilization observingCiv, @Nullable City city, @NotNull LocalUniqueCache uniqueCache) {
        Intrinsics.checkNotNullParameter(uniqueCache, "uniqueCache");
        Stats terrainStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        GameContext gameContext = new GameContext(observingCiv, city, null, this.tile, null, null, null, null, null, null, false, 2036, null);
        TileImprovement improvement = this.tile.getUnpillagedTileImprovement();
        Stats improvementStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        TileImprovement road = this.tile.getUnpillagedRoadImprovement();
        Stats roadStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (city != null) {
            Object unique;
            Sequence<Unique> cachedStatPercentFromObjectCityUniques = uniqueCache.forCityGetMatchingUniques(city, UniqueType.StatPercentFromObject, gameContext);
            Iterator<Unique> iterator2 = cachedStatPercentFromObjectCityUniques.iterator();
            while (iterator2.hasNext()) {
                unique = iterator2.next();
                TileStatFunctions.getTilePercentageStats$addStats(improvement, gameContext, improvementStats, this, observingCiv, terrainStats, road, roadStats, ((Unique)unique).getParams().get(2), Stat.valueOf(((Unique)unique).getParams().get(1)), Float.parseFloat(((Unique)unique).getParams().get(0)));
            }
            Sequence<Unique> cachedAllStatPercentFromObjectCityUniques = uniqueCache.forCityGetMatchingUniques(city, UniqueType.AllStatsPercentFromObject, gameContext);
            unique = cachedAllStatPercentFromObjectCityUniques.iterator();
            while (unique.hasNext()) {
                Unique unique2 = (Unique)unique.next();
                for (Stat stat : Stat.getEntries()) {
                    TileStatFunctions.getTilePercentageStats$addStats(improvement, gameContext, improvementStats, this, observingCiv, terrainStats, road, roadStats, unique2.getParams().get(1), stat, Float.parseFloat(unique2.getParams().get(0)));
                }
            }
        } else if (observingCiv != null) {
            Sequence<Unique> cachedStatPercentFromObjectCivUniques = uniqueCache.forCivGetMatchingUniques(observingCiv, UniqueType.StatPercentFromObject, gameContext);
            Iterator<Unique> cachedAllStatPercentFromObjectCityUniques = cachedStatPercentFromObjectCivUniques.iterator();
            while (cachedAllStatPercentFromObjectCityUniques.hasNext()) {
                Unique unique = cachedAllStatPercentFromObjectCityUniques.next();
                TileStatFunctions.getTilePercentageStats$addStats(improvement, gameContext, improvementStats, this, observingCiv, terrainStats, road, roadStats, unique.getParams().get(2), Stat.valueOf(unique.getParams().get(1)), Float.parseFloat(unique.getParams().get(0)));
            }
            Sequence<Unique> cachedAllStatPercentFromObjectCivUniques = uniqueCache.forCivGetMatchingUniques(observingCiv, UniqueType.AllStatsPercentFromObject, gameContext);
            Iterator<Unique> iterator3 = cachedAllStatPercentFromObjectCivUniques.iterator();
            while (iterator3.hasNext()) {
                Unique unique = iterator3.next();
                for (Stat stat : Stat.getEntries()) {
                    TileStatFunctions.getTilePercentageStats$addStats(improvement, gameContext, improvementStats, this, observingCiv, terrainStats, road, roadStats, unique.getParams().get(1), stat, Float.parseFloat(unique.getParams().get(0)));
                }
            }
        }
        EnumMap<TilePercentageCategory, Stats> enumMap = new EnumMap<TilePercentageCategory, Stats>(TilePercentageCategory.class);
        ((Map)enumMap).put(TilePercentageCategory.Terrain, terrainStats);
        ((Map)enumMap).put(TilePercentageCategory.Improvement, improvementStats);
        ((Map)enumMap).put(TilePercentageCategory.Road, roadStats);
        return enumMap;
    }

    public final float getTileStartScore(@NotNull Stats cityCenterMinStats) {
        boolean bl;
        Tile it;
        Tile element$iv;
        Iterator<Tile> iterator2;
        boolean $i$f$any;
        Sequence<Tile> $this$any$iv;
        float sum;
        block9: {
            Intrinsics.checkNotNullParameter(cityCenterMinStats, "cityCenterMinStats");
            sum = 0.0f;
            Iterator<Tile> iterator3 = this.tile.getTilesInDistance(2).iterator();
            while (iterator3.hasNext()) {
                Tile closeTile = iterator3.next();
                float tileYield = closeTile.getStats().getTileStartYield(Intrinsics.areEqual(closeTile, this.tile) ? cityCenterMinStats : Stats.Companion.getZERO());
                sum += tileYield;
                if (!SequencesKt.contains(this.tile.getNeighbors(), closeTile)) continue;
                sum += tileYield;
            }
            if (this.tile.isHill()) {
                sum -= 2.0f;
            }
            if (this.tile.isAdjacentToRiver()) {
                sum += 2.0f;
            }
            $this$any$iv = this.tile.getNeighbors();
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getBaseTerrain(), "Mountain")) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            sum += 2.0f;
        }
        if (this.tile.isCoastalTile()) {
            sum += 3.0f;
        }
        if (!this.tile.isCoastalTile()) {
            boolean bl3;
            block10: {
                $this$any$iv = this.tile.getNeighbors();
                $i$f$any = false;
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!it.isCoastalTile()) continue;
                    bl3 = true;
                    break block10;
                }
                bl3 = false;
            }
            if (bl3) {
                sum -= 7.0f;
            }
        }
        return sum;
    }

    private final float getTileStartYield(Stats minimumStats) {
        Stats $this$getTileStartYield_u24lambda_u240 = TileStatFunctionsKt.toStats(TileStatFunctions.getTerrainStatsBreakdown$default(this, null, 1, null));
        boolean bl = false;
        if (this.tile.getTileResource() != null) {
            TileResource tileResource = this.tile.getTileResource();
            Intrinsics.checkNotNull(tileResource);
            $this$getTileStartYield_u24lambda_u240.add(tileResource);
        }
        $this$getTileStartYield_u24lambda_u240.add(this.missingFromMinimum($this$getTileStartYield_u24lambda_u240, minimumStats));
        return $this$getTileStartYield_u24lambda_u240.getFood() + $this$getTileStartYield_u24lambda_u240.getProduction() + $this$getTileStartYield_u24lambda_u240.getGold();
    }

    @Readonly
    @NotNull
    public final Stats getStatDiffForImprovement(@NotNull TileImprovement improvement, @NotNull Civilization observingCiv, @Nullable City city, @NotNull LocalUniqueCache cityUniqueCache, @Nullable Stats currentTileStats) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        Intrinsics.checkNotNullParameter(observingCiv, "observingCiv");
        Intrinsics.checkNotNullParameter(cityUniqueCache, "cityUniqueCache");
        Stats stats = currentTileStats;
        if (stats == null) {
            stats = this.getTileStats(city, observingCiv, cityUniqueCache);
        }
        Stats currentStats = stats;
        Tile tileClone = this.tile.clone(false);
        tileClone.setTerrainTransients();
        Tile.setImprovement$default(tileClone, improvement.getName(), null, null, 6, null);
        Stats futureStats = tileClone.getStats().getTileStats(city, observingCiv, cityUniqueCache);
        return futureStats.minus(currentStats);
    }

    public static /* synthetic */ Stats getStatDiffForImprovement$default(TileStatFunctions tileStatFunctions, TileImprovement tileImprovement, Civilization civilization, City city, LocalUniqueCache localUniqueCache, Stats stats, int n, Object object) {
        if ((n & 8) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        if ((n & 0x10) != 0) {
            stats = null;
        }
        return tileStatFunctions.getStatDiffForImprovement(tileImprovement, civilization, city, localUniqueCache, stats);
    }

    @Readonly
    private final Stats getExtraImprovementStats(TileImprovement improvement, Civilization observingCiv, City city) {
        Unique unique;
        Stats stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        TileResource resource = this.tile.getTileResource();
        if (observingCiv.canSeeResource(resource) && resource.isImprovedBy(improvement.getName()) && resource.getImprovementStats() != null) {
            Stats stats2 = resource.getImprovementStats();
            Intrinsics.checkNotNull(stats2);
            stats.add(stats2);
        }
        GameContext conditionalState = new GameContext(observingCiv, city, null, this.tile, null, null, null, null, null, null, false, 2036, null);
        Iterator<Unique> iterator2 = improvement.getMatchingUniques(UniqueType.Stats, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            stats.add(unique.getStats());
        }
        iterator2 = improvement.getMatchingUniques(UniqueType.ImprovementStatsForAdjacencies, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            String adjacent = unique.getParams().get(1);
            Sequence<Tile> $this$count$iv = this.tile.getNeighbors();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<Tile> iterator3 = $this$count$iv.iterator();
            while (iterator3.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator3.next();
                boolean bl = false;
                if (!(it.matchesFilter(adjacent, observingCiv) || Intrinsics.areEqual(it.getUnpillagedRoad().name(), adjacent)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int numberOfBonuses = count$iv;
            stats.add(unique.getStats().times((float)numberOfBonuses));
        }
        iterator2 = improvement.getMatchingUniques(UniqueType.ImprovementStatsOnTile, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (!Tile.matchesFilter$default(this.tile, unique.getParams().get(1), null, 2, null) && (!Intrinsics.areEqual(unique.getParams().get(1), "Fresh water") || !Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null)) && (!Intrinsics.areEqual(unique.getParams().get(1), "non-fresh water") || Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null))) continue;
            stats.add(unique.getStats());
        }
        return stats;
    }

    private static final Terrain riverTerrain_delegate$lambda$0(TileStatFunctions this$0) {
        return this$0.tile.getRuleset().getTerrains().get("River");
    }

    private static final boolean getTileStatsBreakdown$lambda$1(City $city, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return City.matchesFilter$default($city, it.getParams().get(2), null, false, 6, null);
    }

    private static final boolean getTileStatsBreakdown$lambda$2(City $city, TileStatFunctions this$0, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return City.matchesFilter$default($city, it.getParams().get(3), null, false, 6, null) && !Tile.matchesFilter$default(this$0.tile, it.getParams().get(2), null, 2, null);
    }

    private static final void getTilePercentageStats$addStats(TileImprovement improvement, GameContext gameContext, Stats improvementStats, TileStatFunctions this$0, Civilization $observingCiv, Stats terrainStats, TileImprovement road, Stats roadStats, String filter2, Stat stat, float amount) {
        if (improvement != null && TileImprovement.matchesFilter$default(improvement, filter2, gameContext, false, 4, null)) {
            improvementStats.add(stat, amount);
        } else if (this$0.tile.matchesFilter(filter2, $observingCiv)) {
            terrainStats.add(stat, amount);
        } else if (road != null && TileImprovement.matchesFilter$default(road, filter2, gameContext, false, 4, null)) {
            roadStats.add(stat, amount);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/tile/TileStatFunctions$TilePercentageCategory;", "", "<init>", "(Ljava/lang/String;I)V", "Terrain", "Improvement", "Road", "core"})
    public static final class TilePercentageCategory
    extends Enum<TilePercentageCategory> {
        public static final /* enum */ TilePercentageCategory Terrain = new TilePercentageCategory();
        public static final /* enum */ TilePercentageCategory Improvement = new TilePercentageCategory();
        public static final /* enum */ TilePercentageCategory Road = new TilePercentageCategory();
        private static final /* synthetic */ TilePercentageCategory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TilePercentageCategory[] values() {
            return (TilePercentageCategory[])$VALUES.clone();
        }

        public static TilePercentageCategory valueOf(String value) {
            return Enum.valueOf(TilePercentageCategory.class, value);
        }

        @NotNull
        public static EnumEntries<TilePercentageCategory> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tilePercentageCategoryArray = new TilePercentageCategory[]{TilePercentageCategory.Terrain, TilePercentageCategory.Improvement, TilePercentageCategory.Road};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

