/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.transients.CivInfoStatsForNextTurn;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTab;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/screens/overviewscreen/UnitSupplyTable;", "", "<init>", "()V", "create", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "unitOverviewTab", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "supplyTableWidth", "", "addLabeledValue", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "label", "", "value", "", "core"})
public final class UnitSupplyTable {
    @NotNull
    public static final UnitSupplyTable INSTANCE = new UnitSupplyTable();

    private UnitSupplyTable() {
    }

    @NotNull
    public final ExpanderTab create(@NotNull EmpireOverviewScreen overviewScreen, @NotNull UnitOverviewTab unitOverviewTab, @NotNull Civilization viewingPlayer, float supplyTableWidth) {
        NonTransformGroup nonTransformGroup;
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        Intrinsics.checkNotNullParameter(unitOverviewTab, "unitOverviewTab");
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        CivInfoStatsForNextTurn stats = viewingPlayer.getStats();
        int deficit = stats.getUnitSupplyDeficit();
        if (deficit <= 0) {
            nonTransformGroup = null;
        } else {
            NonTransformGroup nonTransformGroup2;
            NonTransformGroup $this$create_u24lambda_u240 = nonTransformGroup2 = new NonTransformGroup();
            boolean bl = false;
            $this$create_u24lambda_u240.setSize(36.0f, 36.0f);
            Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/ExclamationMark", null, 2, null);
            image.setColor(Color.FIREBRICK);
            image.setSize(36.0f, 36.0f);
            Scene2dExtensionsKt.center((Actor)image, $this$create_u24lambda_u240);
            image.setOrigin(1);
            $this$create_u24lambda_u240.addActor(image);
            nonTransformGroup = nonTransformGroup2;
        }
        NonTransformGroup icon = nonTransformGroup;
        return new ExpanderTab("Unit Supply", 18, (Actor)icon, deficit > 0, 0.0f, 0.0f, 0.0f, supplyTableWidth, 0.0f, null, null, () -> UnitSupplyTable.create$lambda$1(overviewScreen, unitOverviewTab), arg_0 -> UnitSupplyTable.create$lambda$2(stats, viewingPlayer, deficit, supplyTableWidth, arg_0), 1888, null);
    }

    private final void addLabeledValue(Table $this$addLabeledValue, String label, int value) {
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(label)).left();
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(value)).right().row();
    }

    private final void addLabeledValue(Table $this$addLabeledValue, String label, String value) {
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(label)).left();
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(value)).right().row();
    }

    private static final Unit create$lambda$1(EmpireOverviewScreen $overviewScreen, UnitOverviewTab $unitOverviewTab) {
        $overviewScreen.resizePage($unitOverviewTab);
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$2(CivInfoStatsForNextTurn $stats, Civilization $viewingPlayer, int $deficit, float $supplyTableWidth, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.defaults().pad(5.0f).fill(false);
        it.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/UnitOverviewTab/UnitSupplyTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.6f), 2, null));
        INSTANCE.addLabeledValue(it, "Base Supply", $stats.getBaseUnitSupply());
        INSTANCE.addLabeledValue(it, "Cities", $stats.getUnitSupplyFromCities());
        INSTANCE.addLabeledValue(it, "Population", $stats.getUnitSupplyFromPop());
        Scene2dExtensionsKt.addSeparator$default(it, null, 0, 0.0f, 7, null);
        INSTANCE.addLabeledValue(it, "Total Supply", $stats.getUnitSupply());
        INSTANCE.addLabeledValue(it, "In Use", $viewingPlayer.getUnits().getCivUnitsSize());
        Scene2dExtensionsKt.addSeparator$default(it, null, 0, 0.0f, 7, null);
        INSTANCE.addLabeledValue(it, "Supply Deficit", $deficit);
        INSTANCE.addLabeledValue(it, "Production Penalty", "" + (int)$stats.getUnitSupplyProductionPenalty() + '%');
        if ($deficit > 0) {
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            Label penaltyLabel = Scene2dExtensionsKt.toLabel$default("Increase your supply or reduce the amount of units to remove the production penalty", color, 0, 0, false, 14, null);
            penaltyLabel.setWrap(true);
            it.add((Actor)penaltyLabel).colspan(2).left().width($supplyTableWidth).row();
        }
        return Unit.INSTANCE;
    }
}

