/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardOCR;
import boardsync.BoardPosition;
import boardsync.Config;
import boardsync.ToolFrame;
import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

public class BoardSyncTool {
    public static ResourceBundle resourceBundle = ResourceBundle.getBundle("l10n.DisplayStrings");
    public static Language language = Language.Chinese;
    private static boolean useJavaLooks = false;
    private static int fontSize = 12;
    public static int boardWidth = 19;
    public static int boardHeight = 19;
    public static boolean isGettingScreen = false;
    public static BufferedImage screenImage;
    public static int screenImageStartX;
    public static int screenImageStartY;
    public static BoardPosition boardPosition;
    public static Config config;
    public static ToolFrame toolFrame;
    public static boolean isWindows;

    static {
        boardPosition = null;
        isWindows = System.getProperties().getProperty("os.name").toUpperCase().indexOf("WINDOWS") != -1;
    }

    public static void main(String[] args) {
        if (args.length == 5) {
            if (args[0].equals("cn")) {
                language = Language.Chinese;
            } else if (args[0].equals("en")) {
                language = Language.English;
            } else if (args[0].equals("jp")) {
                language = Language.Japanese;
            } else if (args[0].equals("kr")) {
                language = Language.Korean;
            }
            useJavaLooks = args[1].equals("true");
            try {
                fontSize = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                boardWidth = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            try {
                boardHeight = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        switch (language) {
            case Chinese: {
                resourceBundle = ResourceBundle.getBundle("l10n.DisplayStrings", new Locale("zh", "CN"));
                break;
            }
            case English: {
                resourceBundle = ResourceBundle.getBundle("l10n.DisplayStrings", new Locale("en", "US"));
                break;
            }
            case Japanese: {
                resourceBundle = ResourceBundle.getBundle("l10n.DisplayStrings", new Locale("ja", "JP"));
                break;
            }
            case Korean: {
                resourceBundle = ResourceBundle.getBundle("l10n.DisplayStrings", new Locale("ko"));
            }
        }
        BoardSyncTool.setLookAndFeel();
        try {
            config = new Config();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        toolFrame = new ToolFrame();
        toolFrame.setVisible(true);
        BoardSyncTool.startGetInputStreamThread();
    }

    private static void startGetInputStreamThread() {
        final BufferedReader inputReader = new BufferedReader(new InputStreamReader(System.in));
        new Thread(){

            @Override
            public void run() {
                try {
                    final Robot robot = new Robot();
                    String line = "";
                    while ((line = inputReader.readLine()) != null) {
                        String[] params;
                        if (line.startsWith("place") && BoardSyncTool.toolFrame.chkBothSync.isSelected() && BoardSyncTool.toolFrame.isKeepSyncing && !BoardSyncTool.toolFrame.keepSyncThreadInterrupted && (params = line.trim().split(" ")).length == 3) {
                            new Thread(){

                                @Override
                                public void run() {
                                    BoardSyncTool.place(params[1], params[2], robot);
                                }
                            }.start();
                        }
                        if (!line.equals("quit")) continue;
                        BoardSyncTool.shutdown();
                    }
                }
                catch (AWTException | IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public static void place(String strX, String strY, Robot robot) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        int x = -1;
        int y = -1;
        int maxTimes = 10;
        try {
            x = Integer.parseInt(strX.trim());
            y = Integer.parseInt(strY.trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        float hGap = (float)BoardSyncTool.boardPosition.height / (float)boardHeight;
        float vGap = (float)BoardSyncTool.boardPosition.width / (float)boardWidth;
        int posX = (int)Math.round(((double)x + 0.5) * (double)vGap + (double)BoardSyncTool.boardPosition.x);
        int posY = (int)Math.round(((double)y + 0.5) * (double)hGap + (double)BoardSyncTool.boardPosition.y);
        int verifyX = Math.round((float)x * vGap + (float)BoardSyncTool.boardPosition.x);
        int verifyY = Math.round((float)y * hGap + (float)BoardSyncTool.boardPosition.y);
        try {
            do {
                BoardSyncTool.mouseClick(posX, posY, robot);
            } while (BoardSyncTool.config.verifyPlacedMove && --maxTimes > 0 && !BoardSyncTool.verifyMove(verifyX, verifyY, Math.round(vGap), Math.round(hGap), x, y));
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        robot.mouseMove((int)point.getX(), (int)point.getY());
    }

    private static boolean verifyMove(int x, int y, int width, int height, int moveX, int moveY) throws AWTException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        BoardOCR boardOCR = new BoardOCR();
        return boardOCR.hasMoveAt(x, y, width, height, moveX, moveY);
    }

    private static void mouseClick(int posX, int posY, Robot robot) {
        try {
            robot.mouseMove(posX, posY);
            Thread.sleep(30L);
            robot.mouseMove(posX, posY);
            robot.mousePress(16);
            Thread.sleep(30L);
            robot.mouseRelease(16);
            Thread.sleep(30L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static void setLookAndFeel() {
        try {
            BoardSyncTool.setUIFont(new FontUIResource("Dialog.plain", 0, fontSize));
            UIManager.put("OptionPane.buttonFont", new FontUIResource("Dialog.plain", 0, fontSize));
            UIManager.put("OptionPane.messageFont", new FontUIResource("Dialog.plain", 0, fontSize));
            if (useJavaLooks) {
                String lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            } else {
                String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        try {
            config.saveAndWriteConfig();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.exit(0);
    }

    public static enum Language {
        Chinese,
        English,
        Japanese,
        Korean;

    }
}

