/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardSyncTool;
import boardsync.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Config {
    private String configFilename = "readboard_boofcv_config.txt";
    public JSONObject config;
    public int grayOffset = 50;
    public int blackOffset = 96;
    public int whiteOffset = 96;
    public int blackPercent = 33;
    public int whitePercent = 33;
    public int keepSyncIntervalMillseconds = 200;
    public boolean autoMinimize = true;
    public int locationX = 50;
    public int locationY = 50;
    public boolean verifyPlacedMove = true;
    public boolean lastTimeBothSync = false;
    public int lastTimeTotalTime = -1;
    public int lastTimeTotalVisits = -1;
    public int lastTimeFirstVisits = -1;
    public int bluePercent = 1;
    public int redPercent = 1;
    public boolean playPonder = true;

    public Config() throws IOException {
        try {
            this.config = this.readConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = this.createDefaultConfig();
            this.writeConfig(this.config);
        }
        this.grayOffset = this.config.optInt("gray-offset", 50);
        this.blackOffset = this.config.optInt("black-offset", 96);
        this.whiteOffset = this.config.optInt("white-offset", 96);
        this.blackPercent = this.config.optInt("black-percent", 33);
        this.whitePercent = this.config.optInt("white-percent", 33);
        this.keepSyncIntervalMillseconds = this.config.optInt("keep-sync-interval-millseconds", 200);
        this.autoMinimize = this.config.optBoolean("auto-minimize", true);
        this.locationX = this.config.optInt("location-x", 50);
        this.locationY = this.config.optInt("location-y", 50);
        this.verifyPlacedMove = this.config.optBoolean("verify-placed-move", true);
        this.lastTimeBothSync = this.config.optBoolean("last-time-both-sync", false);
        this.lastTimeTotalTime = this.config.optInt("last-time-total-time", -1);
        this.lastTimeTotalVisits = this.config.optInt("last-time-total-visits", -1);
        this.lastTimeFirstVisits = this.config.optInt("last-time-fitst-visits", -1);
        this.playPonder = this.config.optBoolean("play-ponder", true);
    }

    public void saveAndWriteConfig() throws IOException {
        this.config.put("gray-offset", this.grayOffset);
        this.config.put("black-offset", this.blackOffset);
        this.config.put("white-offset", this.whiteOffset);
        this.config.put("black-percent", this.blackPercent);
        this.config.put("white-percent", this.whitePercent);
        this.config.put("keep-sync-interval-millseconds", this.keepSyncIntervalMillseconds);
        this.config.put("auto-minimize", this.autoMinimize);
        this.config.put("verify-placed-move", this.verifyPlacedMove);
        this.locationX = BoardSyncTool.toolFrame.getLocation().x;
        this.locationY = BoardSyncTool.toolFrame.getLocation().y;
        this.config.put("location-x", this.locationX);
        this.config.put("location-y", this.locationY);
        this.lastTimeBothSync = BoardSyncTool.toolFrame.chkBothSync.isSelected();
        this.lastTimeTotalTime = Utils.parseTextToInt(BoardSyncTool.toolFrame.txtTotalTime, -1);
        this.lastTimeTotalVisits = Utils.parseTextToInt(BoardSyncTool.toolFrame.txtFirstVisits, -1);
        this.lastTimeFirstVisits = Utils.parseTextToInt(BoardSyncTool.toolFrame.txtFirstVisits, -1);
        this.config.put("last-time-both-sync", this.lastTimeBothSync);
        this.config.put("last-time-total-time", this.lastTimeTotalTime);
        this.config.put("last-time-total-visits", this.lastTimeTotalVisits);
        this.config.put("last-time-fitst-visits", this.lastTimeFirstVisits);
        this.config.put("play-ponder", this.playPonder);
        this.writeConfig(this.config);
    }

    private void writeConfig(JSONObject config) throws IOException {
        File file = new File(this.configFilename);
        file.createNewFile();
        FileOutputStream fp = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fp, "utf-8");
        writer.write(config.toString(2));
        writer.close();
        fp.close();
    }

    private JSONObject readConfig() throws FileNotFoundException, UnsupportedEncodingException {
        File file = new File(this.configFilename);
        FileInputStream fp = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)fp, "utf-8");
        return new JSONObject(new JSONTokener(reader));
    }

    private JSONObject createDefaultConfig() {
        JSONObject config = new JSONObject();
        config.put("gray-offset", this.grayOffset);
        config.put("black-offset", this.blackOffset);
        config.put("white-offset", this.whiteOffset);
        config.put("black-percent", this.blackPercent);
        config.put("white-percent", this.whitePercent);
        config.put("keep-sync-interval-millseconds", this.keepSyncIntervalMillseconds);
        config.put("auto-minimize", this.autoMinimize);
        config.put("verify-placed-move", this.verifyPlacedMove);
        config.put("location-x", this.locationX);
        config.put("location-y", this.locationY);
        config.put("last-time-both-sync", this.lastTimeBothSync);
        config.put("last-time-total-time", this.lastTimeTotalTime);
        config.put("last-time-total-visits", this.lastTimeTotalVisits);
        config.put("last-time-fitst-visits", this.lastTimeFirstVisits);
        config.put("play-ponder", this.playPonder);
        return config;
    }
}

