/*
 * Decompiled with CFR 0.152.
 */
package boardsync;

import boardsync.BoardSyncTool;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;

public class ScreenShotDialog
extends JDialog {
    ScreenShotDialog t;
    private int startX;
    private int startY;
    private int capWidth;
    private int capHeight;
    private static final long serialVersionUID = 1L;
    private int orgx;
    private int orgy;
    private int endx;
    private int endy;
    private int orgxMouse;
    private int orgyMouse;
    private int endxMouse;
    private int endyMouse;
    private Dimension screenSize;
    private BufferedImage imageShow;
    private BufferedImage imageOut;
    private Color backGroundColor = new Color(0, 0, 0, 25);

    public ScreenShotDialog() {
        try {
            this.t = new ScreenShotDialog(null){
                private static final long serialVersionUID = 1L;

                @Override
                protected void capture() {
                    super.capture();
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start() {
        try {
            this.t.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(2));
        if (this.imageShow != null) {
            g.drawImage(this.imageShow, 0, 0, this);
        }
    }

    private void drawSelectArea() {
        if (this.orgx == -1 || this.orgy == -1) {
            return;
        }
        this.imageShow = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g = (Graphics2D)this.imageShow.getGraphics();
        int x = Math.min(this.orgx, this.endx);
        int y = Math.min(this.orgy, this.endy);
        int width = Math.abs(this.endx - this.orgx) + 1;
        int height = Math.abs(this.endy - this.orgy) + 1;
        this.startX = Math.min(this.orgxMouse, this.endxMouse);
        this.startY = Math.min(this.orgyMouse, this.endyMouse);
        this.capWidth = width;
        this.capHeight = height;
        g.setBackground(this.backGroundColor);
        g.clearRect(x, y, width, height);
        g.setColor(Color.BLUE);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect(x, y, width, height);
        this.repaint();
    }

    private void bindSelectAreaListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ScreenShotDialog.this.orgx = e.getX();
                    ScreenShotDialog.this.orgy = e.getY();
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    ScreenShotDialog.this.orgxMouse = point.x;
                    ScreenShotDialog.this.orgyMouse = point.y;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScreenShotDialog.this.orgx = -1;
                ScreenShotDialog.this.orgy = -1;
                ScreenShotDialog.this.capture();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ScreenShotDialog.this.endx = e.getX();
                ScreenShotDialog.this.endy = e.getY();
                ScreenShotDialog.this.drawSelectArea();
                Point point = MouseInfo.getPointerInfo().getLocation();
                ScreenShotDialog.this.endxMouse = point.x;
                ScreenShotDialog.this.endyMouse = point.y;
            }
        });
    }

    public ScreenShotDialog(JDialog owner) throws Exception {
        super(owner);
    }

    public void open() throws Exception {
        this.bindSelectAreaListener();
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setBackground(this.backGroundColor);
        this.setSize(this.screenSize);
        this.setLocation(0, 0);
        this.setVisible(true);
    }

    protected void close() {
        if (this.capWidth > 0 && this.capHeight > 0) {
            try {
                Robot robot = new Robot();
                this.startX -= this.capWidth / BoardSyncTool.boardWidth;
                this.startY -= this.capWidth / BoardSyncTool.boardHeight;
                this.capWidth += 2 * this.capWidth / BoardSyncTool.boardWidth;
                this.capHeight += 2 * this.capWidth / BoardSyncTool.boardHeight;
                this.imageOut = robot.createScreenCapture(new Rectangle(this.startX, this.startY, this.capWidth, this.capHeight));
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            BoardSyncTool.screenImage = this.imageOut;
            BoardSyncTool.screenImageStartX = this.startX;
            BoardSyncTool.screenImageStartY = this.startY;
        }
        this.dispose();
        BoardSyncTool.isGettingScreen = false;
    }

    protected void capture() {
        this.close();
    }

    public BufferedImage screenCapture(Dimension screenSize) throws AWTException {
        Robot robot = new Robot();
        return robot.createScreenCapture(new Rectangle(0, 0, screenSize.width, screenSize.height));
    }
}

