/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.intensity;

import boofcv.abst.feature.detect.intensity.BaseGeneralFeatureIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.struct.ListIntPoint2D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class WrapperHessianDerivBlobIntensity<I extends ImageGray<I>, D extends ImageGray<D>>
extends BaseGeneralFeatureIntensity<I, D> {
    HessianBlobIntensity.Type type;
    Method m;
    boolean minimum;

    public WrapperHessianDerivBlobIntensity(HessianBlobIntensity.Type type, Class<D> derivType) {
        super(null, derivType);
        this.type = type;
        try {
            switch (type) {
                case DETERMINANT: {
                    this.minimum = true;
                    this.m = HessianBlobIntensity.class.getMethod("determinant", GrayF32.class, derivType, derivType, derivType);
                    break;
                }
                case TRACE: {
                    this.minimum = true;
                    this.m = HessianBlobIntensity.class.getMethod("trace", GrayF32.class, derivType, derivType);
                    break;
                }
                default: {
                    throw new RuntimeException("Not supported yet");
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void process(I image, D derivX, D derivY, D derivXX, D derivYY, D derivXY) {
        this.init(((ImageGray)image).width, ((ImageGray)image).height);
        try {
            switch (this.type) {
                case DETERMINANT: {
                    this.m.invoke(null, this.intensity, derivXX, derivYY, derivXY);
                    break;
                }
                case TRACE: {
                    this.m.invoke(null, this.intensity, derivXX, derivYY);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public ListIntPoint2D getCandidatesMin() {
        return null;
    }

    @Override
    @Nullable
    public ListIntPoint2D getCandidatesMax() {
        return null;
    }

    @Override
    public boolean getRequiresGradient() {
        return false;
    }

    @Override
    public boolean getRequiresHessian() {
        return true;
    }

    @Override
    public boolean hasCandidates() {
        return false;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }

    @Override
    public boolean localMinimums() {
        return this.minimum;
    }

    @Override
    public boolean localMaximums() {
        return true;
    }
}

