/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectEdgeLines;
import boofcv.abst.feature.detect.line.DetectLine;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.line.LineParametric2D_F32;
import java.util.List;

public class DetectEdgeLinesToLines<T extends ImageGray<T>, D extends ImageGray<D>>
implements DetectLine<T> {
    DetectEdgeLines<D> detector;
    ImageGradient<T, D> gradient;
    D derivX;
    D derivY;

    public DetectEdgeLinesToLines(DetectEdgeLines<D> detector, ImageGradient<T, D> gradient) {
        this.detector = detector;
        this.gradient = gradient;
        this.derivX = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        this.derivY = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
    }

    public DetectEdgeLinesToLines(DetectEdgeLines<D> detector, Class<T> imageType, Class<D> derivType) {
        this(detector, FactoryDerivative.sobel(imageType, derivType));
    }

    @Override
    public List<LineParametric2D_F32> detect(T input) {
        ((ImageGray)this.derivX).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        this.detector.detect(this.derivX, this.derivY);
        return this.detector.getFoundLines();
    }

    @Override
    public ImageType<T> getInputType() {
        return this.gradient.getInputType();
    }
}

