/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLineSegment;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.ConnectLinesGrid;
import boofcv.alg.feature.detect.line.GridRansacLineDetector;
import boofcv.alg.feature.detect.line.LineImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.MatrixOfList;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineSegment2D_F32;
import java.util.List;

public class DetectLineSegmentsGridRansac<T extends ImageGray<T>, D extends ImageGray<D>>
implements DetectLineSegment<T> {
    GridRansacLineDetector<D> detectorGrid;
    ConnectLinesGrid connect;
    D derivX;
    D derivY;
    GrayF32 edgeIntensity;
    GrayU8 detected;
    ImageGradient<T, D> gradient;
    double edgeThreshold;

    public DetectLineSegmentsGridRansac(GridRansacLineDetector<D> detectorGrid, ConnectLinesGrid connect, ImageGradient<T, D> gradient, double edgeThreshold, Class<T> imageType, Class<D> derivType) {
        this.detectorGrid = detectorGrid;
        this.connect = connect;
        this.gradient = gradient;
        this.edgeThreshold = edgeThreshold;
        this.derivX = GeneralizedImageOps.createSingleBand(derivType, 1, 1);
        this.derivY = GeneralizedImageOps.createSingleBand(derivType, 1, 1);
        this.edgeIntensity = new GrayF32(1, 1);
        this.detected = new GrayU8(1, 1);
    }

    @Override
    public List<LineSegment2D_F32> detect(T input) {
        ((ImageGray)this.derivX).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.edgeIntensity.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.detected.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.edgeIntensity);
        GThresholdImageOps.threshold(this.edgeIntensity, this.detected, this.edgeThreshold, false);
        this.detectorGrid.process(this.derivX, this.derivY, this.detected);
        MatrixOfList<LineSegment2D_F32> grid = this.detectorGrid.getFoundLines();
        if (this.connect != null) {
            this.connect.process(grid);
        }
        List<LineSegment2D_F32> found = grid.createSingleList();
        LineImageOps.mergeSimilar(found, 0.09424778f, 5.0f);
        return found;
    }
}

