/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.CalibrationDetectorSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.DetectFiducialSquareGrid;
import boofcv.alg.fiducial.square.DetectFiducialSquareBinary;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class CalibrationDetectorSquareFiducialGrid
implements DetectorFiducialCalibration {
    int numRows;
    int numCols;
    int numPointRows;
    int numPointCols;
    List<Point2D_F64> layoutPoints;
    DetectFiducialSquareGrid<GrayF32> detector;
    CalibrationObservation observations;

    public CalibrationDetectorSquareFiducialGrid(ConfigSquareGridBinary config) {
        DetectFiducialSquareBinary fiducialDetector = (DetectFiducialSquareBinary)FactoryFiducial.squareBinary(config.configDetector, config.configThreshold, GrayF32.class).getAlgorithm();
        this.detector = new DetectFiducialSquareGrid(config.numRows, config.numCols, config.ids, fiducialDetector);
        this.numRows = config.numRows;
        this.numCols = config.numCols;
        this.numPointRows = 2 * this.numRows;
        this.numPointCols = 2 * this.numCols;
        this.layoutPoints = CalibrationDetectorSquareGrid.createLayout(this.numRows, this.numCols, config.squareWidth, config.spaceWidth);
    }

    @Override
    public boolean process(GrayF32 input) {
        this.observations = new CalibrationObservation(input.width, input.height);
        if (!this.detector.detect(input)) {
            return false;
        }
        List<DetectFiducialSquareGrid.Detection> detections = this.detector.getDetections();
        for (int i = 0; i < detections.size(); ++i) {
            DetectFiducialSquareGrid.Detection d = detections.get(i);
            int row = d.gridIndex / this.numCols;
            int col = d.gridIndex % this.numCols;
            int pointRow = row * 2;
            int pointCol = col * 2;
            this.observations.add(d.location.a, this.getPointIndex(pointRow, pointCol));
            this.observations.add(d.location.b, this.getPointIndex(pointRow, pointCol + 1));
            this.observations.add(d.location.c, this.getPointIndex(pointRow + 1, pointCol + 1));
            this.observations.add(d.location.d, this.getPointIndex(pointRow + 1, pointCol));
        }
        this.observations.sort();
        return true;
    }

    private int getPointIndex(int row, int col) {
        return row * this.numPointCols + col;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        return this.observations;
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.layoutPoints;
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion == null) {
            this.detector.getDetector().getSquareDetector().setLensDistortion(width, height, null, null);
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
            this.detector.getDetector().getSquareDetector().setLensDistortion(width, height, distToUndist, undistToDist);
        }
    }
}

