/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.grid.DetectSquareGridFiducial;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrationDetectorSquareGrid
implements DetectorFiducialCalibration {
    DetectSquareGridFiducial<GrayF32> detector;
    List<Point2D_F64> layoutPoints;
    CalibrationObservation detected;

    public CalibrationDetectorSquareGrid(ConfigSquareGrid configDet, ConfigGridDimen configDimen) {
        double spaceToSquareRatio = configDimen.shapeDistance / configDimen.shapeSize;
        InputToBinary<GrayF32> inputToBinary = FactoryThresholdBinary.threshold(configDet.thresholding, GrayF32.class);
        DetectPolygonBinaryGrayRefine<GrayF32> detectorSquare = FactoryShapeDetector.polygon(configDet.square, GrayF32.class);
        this.detector = new DetectSquareGridFiducial<GrayF32>(configDimen.numRows, configDimen.numCols, spaceToSquareRatio, inputToBinary, detectorSquare);
        this.layoutPoints = CalibrationDetectorSquareGrid.createLayout(configDimen.numRows, configDimen.numCols, configDimen.shapeSize, configDimen.shapeDistance);
    }

    @Override
    public boolean process(GrayF32 input) {
        this.detected = new CalibrationObservation(input.width, input.height);
        if (this.detector.process(input)) {
            List<PointIndex2D_F64> found = this.detector.getCalibrationPoints();
            for (int i = 0; i < found.size(); ++i) {
                this.detected.add((Point2D_F64)found.get((int)i).p, i);
            }
            return true;
        }
        return false;
    }

    public static List<Point2D_F64> createLayout(int numRows, int numCols, double squareWidth, double spaceWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        double width = (double)numCols * squareWidth + (double)(numCols - 1) * spaceWidth;
        double height = (double)numRows * squareWidth + (double)(numRows - 1) * spaceWidth;
        double startX = -width / 2.0;
        double startY = -height / 2.0;
        for (int i = numRows - 1; i >= 0; --i) {
            double y = startY + (double)i * (squareWidth + spaceWidth) + squareWidth;
            ArrayList<Point2D_F64> top = new ArrayList<Point2D_F64>();
            ArrayList<Point2D_F64> bottom = new ArrayList<Point2D_F64>();
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * (squareWidth + spaceWidth);
                top.add(new Point2D_F64(x, y));
                top.add(new Point2D_F64(x + squareWidth, y));
                bottom.add(new Point2D_F64(x, y - squareWidth));
                bottom.add(new Point2D_F64(x + squareWidth, y - squareWidth));
            }
            all.addAll(top);
            all.addAll(bottom);
        }
        return all;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        return this.detected;
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.layoutPoints;
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion == null) {
            this.detector.getDetectorSquare().setLensDistortion(width, height, null, null);
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
            this.detector.getDetectorSquare().setLensDistortion(width, height, distToUndist, undistToDist);
        }
    }

    public DetectSquareGridFiducial<GrayF32> getAlgorithm() {
        return this.detector;
    }

    public int getGridRows() {
        return this.detector.getRows();
    }

    public int getGridColumns() {
        return this.detector.getColumns();
    }

    public int getPointRows() {
        return this.detector.getCalibrationRows();
    }

    public int getPointColumns() {
        return this.detector.getCalibrationCols();
    }
}

