/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.PruneStructureFromSceneMetric;
import boofcv.abst.geo.bundle.ScaleSceneStructure;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class MetricBundleAdjustmentUtils
implements VerbosePrint {
    public final ConfigConverge configConverge = new ConfigConverge(1.0E-5, 1.0E-5, 30);
    public boolean configScale = false;
    public double keepFraction = 1.0;
    public final SceneStructureMetric structure;
    public final SceneObservations observations = new SceneObservations();
    public BundleAdjustment<SceneStructureMetric> sba = FactoryMultiView.bundleSparseMetric(null);
    public TriangulateNViewsMetricH triangulator;
    public ScaleSceneStructure scaler = new ScaleSceneStructure();
    @Nullable
    PrintStream verbose;

    public MetricBundleAdjustmentUtils(@Nullable ConfigTriangulation triangulation, boolean homogenous) {
        this.triangulator = FactoryMultiView.triangulateNViewMetricH(triangulation);
        this.structure = new SceneStructureMetric(homogenous);
    }

    public MetricBundleAdjustmentUtils() {
        this(null, true);
    }

    public boolean process() {
        if (this.configConverge.maxIterations == 0) {
            return true;
        }
        if (this.configScale) {
            this.scaler.applyScale(this.structure, this.observations);
        }
        this.sba.configure(this.configConverge.ftol, this.configConverge.gtol, this.configConverge.maxIterations);
        this.sba.setParameters(this.structure, this.observations);
        if (this.verbose != null) {
            this.printAverageError("BEFORE", this.verbose);
        }
        if (!this.sba.optimize(this.structure)) {
            return false;
        }
        if (this.verbose != null) {
            this.printAverageError("AFTER", this.verbose);
        }
        if (this.keepFraction < 1.0) {
            this.prune(this.keepFraction, -1, 1);
            this.sba.setParameters(this.structure, this.observations);
            if (!this.sba.optimize(this.structure)) {
                return false;
            }
            if (this.verbose != null) {
                this.printAverageError("PRUNED-AFTER", this.verbose);
            }
        }
        if (this.configScale) {
            this.scaler.undoScale(this.structure, this.observations);
        }
        return true;
    }

    private void printAverageError(String location, PrintStream out) {
        double averageError = Math.sqrt(this.sba.getFitScore()) / (double)this.observations.getObservationCount();
        out.printf("SBA %13s average error=%.2e\n", location, averageError);
    }

    public void prune(double keepFraction, int pruneViews, int prunePoints) {
        prunePoints = Math.max(1, prunePoints);
        PruneStructureFromSceneMetric pruner = new PruneStructureFromSceneMetric(this.structure, this.observations);
        pruner.pruneObservationsByErrorRank(keepFraction);
        if (pruneViews > 0 && pruner.pruneViews(pruneViews)) {
            pruner.pruneUnusedMotions();
        }
        pruner.prunePoints(prunePoints);
    }

    public void printCounts(PrintStream out) {
        out.println("Bundle: Points=" + this.structure.points.size + " Views=" + this.structure.views.size + " Cameras=" + this.structure.cameras.size);
        for (int viewIdx = 0; viewIdx < this.observations.views.size; ++viewIdx) {
            out.println("view[" + viewIdx + "].observations.size=" + ((SceneObservations.View)this.observations.views.get(viewIdx)).size());
        }
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public ConfigConverge getConfigConverge() {
        return this.configConverge;
    }

    public boolean isConfigScale() {
        return this.configScale;
    }

    public void setConfigScale(boolean configScale) {
        this.configScale = configScale;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public SceneObservations getObservations() {
        return this.observations;
    }

    public BundleAdjustment<SceneStructureMetric> getSba() {
        return this.sba;
    }

    public void setSba(BundleAdjustment<SceneStructureMetric> sba) {
        this.sba = sba;
    }

    public TriangulateNViewsMetricH getTriangulator() {
        return this.triangulator;
    }

    public void setTriangulator(TriangulateNViewsMetricH triangulator) {
        this.triangulator = triangulator;
    }

    public ScaleSceneStructure getScaler() {
        return this.scaler;
    }
}

