/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.scene.nister2006;

import boofcv.alg.scene.bow.BowDistanceTypes;
import boofcv.alg.scene.vocabtree.ConfigHierarchicalVocabularyTree;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import org.ddogleg.clustering.ConfigKMeans;

public class ConfigRecognitionNister2006
implements Configuration {
    public final ConfigKMeans kmeans = new ConfigKMeans();
    public final ConfigHierarchicalVocabularyTree tree = new ConfigHierarchicalVocabularyTree();
    public BowDistanceTypes distanceNorm = BowDistanceTypes.L1;
    public int minimumDepthFromRoot = 0;
    public final ConfigLength queryMaximumImagesInNode = ConfigLength.relative(0.002, 5000.0);
    public final ConfigLength learningMaximumImagesInNode = ConfigLength.relative(1.0, 1.0);
    public final ConfigLength learningMinimumPointsForChildren = ConfigLength.fixed(0.0);
    public boolean learnNodeWeights = true;
    public int featureSingleWordHops = Integer.MAX_VALUE;
    public long randSeed = -559038737L;

    public ConfigRecognitionNister2006() {
        this.tree.branchFactor = 20;
        this.tree.maximumLevel = 4;
        this.minimumDepthFromRoot = 2;
        this.kmeans.reseedAfterIterations = 30;
        this.kmeans.maxIterations = 30;
        this.kmeans.maxReSeed = 0;
    }

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.minimumDepthFromRoot >= 0, "Maximum level must be a non-negative integer");
        BoofMiscOps.checkTrue(this.featureSingleWordHops >= 0, "Can't hop backwards in the tree");
        this.kmeans.checkValidity();
        this.tree.checkValidity();
        this.queryMaximumImagesInNode.checkValidity();
        this.learningMaximumImagesInNode.checkValidity();
        this.learningMinimumPointsForChildren.checkValidity();
    }

    public void setTo(ConfigRecognitionNister2006 src) {
        this.kmeans.setTo(src.kmeans);
        this.tree.setTo(src.tree);
        this.distanceNorm = src.distanceNorm;
        this.minimumDepthFromRoot = src.minimumDepthFromRoot;
        this.randSeed = src.randSeed;
        this.learnNodeWeights = src.learnNodeWeights;
        this.featureSingleWordHops = src.featureSingleWordHops;
        this.queryMaximumImagesInNode.setTo(src.queryMaximumImagesInNode);
        this.learningMaximumImagesInNode.setTo(src.learningMaximumImagesInNode);
        this.learningMinimumPointsForChildren.setTo(src.learningMinimumPointsForChildren);
    }

    public int getFeatureSingleWordHops() {
        return this.featureSingleWordHops;
    }

    public void setFeatureSingleWordHops(int featureSingleWordHops) {
        this.featureSingleWordHops = featureSingleWordHops;
    }
}

