/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.transform.fft;

import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.alg.transform.fft.DiscreteFourierTransformOps;
import boofcv.alg.transform.fft.GeneralPurposeFFT_F32_2D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.InterleavedF32;

public class GeneralFft_to_DiscreteFourierTransform_F32
implements DiscreteFourierTransform<GrayF32, InterleavedF32> {
    private int prevWidth = -1;
    private int prevHeight = -1;
    private GeneralPurposeFFT_F32_2D alg;
    private InterleavedF32 tmp = new InterleavedF32(1, 1, 2);
    private boolean modifyInputs = false;

    @Override
    public void forward(GrayF32 image, InterleavedF32 transform) {
        DiscreteFourierTransformOps.checkImageArguments(image, transform);
        if (image.isSubimage() || transform.isSubimage()) {
            throw new IllegalArgumentException("Subimages are not supported");
        }
        this.checkDeclareAlg(image);
        int N = image.width * image.height;
        System.arraycopy(image.data, 0, transform.data, 0, N);
        this.alg.realForwardFull(transform.data);
    }

    @Override
    public void inverse(InterleavedF32 transform, GrayF32 image) {
        InterleavedF32 workImage;
        DiscreteFourierTransformOps.checkImageArguments(image, transform);
        if (image.isSubimage() || transform.isSubimage()) {
            throw new IllegalArgumentException("Subimages are not supported");
        }
        this.checkDeclareAlg(image);
        if (this.modifyInputs) {
            workImage = transform;
        } else {
            this.tmp.reshape(transform.width, transform.height);
            this.tmp.setTo(transform);
            workImage = this.tmp;
        }
        this.alg.complexInverse(workImage.data, true);
        int N = image.width * image.height;
        for (int i = 0; i < N; ++i) {
            image.data[i] = workImage.data[i * 2];
        }
    }

    private void checkDeclareAlg(GrayF32 image) {
        if (this.prevWidth != image.width || this.prevHeight != image.height) {
            this.prevWidth = image.width;
            this.prevHeight = image.height;
            this.alg = new GeneralPurposeFFT_F32_2D(image.height, image.width);
        }
    }

    @Override
    public void setModifyInputs(boolean modify) {
        this.modifyInputs = modify;
    }

    @Override
    public boolean isModifyInputs() {
        return this.modifyInputs;
    }
}

