/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.pinhole;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;

public class PinholeNtoP_F64
implements Point2Transform2_F64 {
    private double fx;
    private double fy;
    private double skew;
    private double cx;
    private double cy;

    public PinholeNtoP_F64(PinholeNtoP_F64 original) {
        this.fx = original.fx;
        this.fy = original.fy;
        this.skew = original.skew;
        this.cx = original.cx;
        this.cy = original.cy;
    }

    public PinholeNtoP_F64() {
    }

    public PinholeNtoP_F64 setK(CameraPinhole pinhole) {
        return this.setK(pinhole.fx, pinhole.fy, pinhole.skew, pinhole.cx, pinhole.cy);
    }

    public PinholeNtoP_F64 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        return this;
    }

    @Override
    public void compute(double x, double y, Point2D_F64 out) {
        out.x = this.fx * x + this.skew * y + this.cx;
        out.y = this.fy * y + this.cy;
    }

    @Override
    public PinholeNtoP_F64 copyConcurrent() {
        return new PinholeNtoP_F64(this);
    }
}

