/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.llah;

import boofcv.alg.feature.describe.llah.LlahDocument;
import boofcv.alg.feature.describe.llah.LlahFeature;
import boofcv.alg.feature.describe.llah.LlahHashTable;
import boofcv.alg.feature.describe.llah.LlahHasher;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.helper.KdTreePoint2D_F64;
import georegression.struct.point.Point2D_F64;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.ddogleg.combinatorics.Combinations;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;

public class LlahOperations {
    final int numberOfNeighborsN;
    final int sizeOfCombinationM;
    final int numberOfInvariants;
    final List<Point2D_F64> setM = new ArrayList<Point2D_F64>();
    final List<Point2D_F64> permuteM = new ArrayList<Point2D_F64>();
    LlahHasher hasher;
    final LlahHashTable hashTable = new LlahHashTable();
    final DogArray<LlahDocument> documents = new DogArray<LlahDocument>(LlahDocument::new, LlahDocument::reset);
    final NearestNeighbor<Point2D_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint2D_F64());
    private final NearestNeighbor.Search<Point2D_F64> search = this.nn.createSearch();
    private final DogArray<NnData<Point2D_F64>> resultsNN = new DogArray<NnData>(NnData::new);
    final List<Point2D_F64> neighbors = new ArrayList<Point2D_F64>();
    private final double[] angles;
    private final QuickSort_F64 sorter = new QuickSort_F64();
    private final DogArray<FoundDocument> resultsStorage = new DogArray<FoundDocument>(FoundDocument::new);
    private final TIntObjectHashMap<FoundDocument> foundMap = new TIntObjectHashMap();
    private final DogArray<LlahFeature> allFeatures;
    private final Combinations<Point2D_F64> combinator = new Combinations();
    DogArray<DotVotingBooth> votingBooths = new DogArray<DotVotingBooth>(DotVotingBooth::new, DotVotingBooth::reset);

    public LlahOperations(int numberOfNeighborsN, int sizeOfCombinationM, LlahHasher hasher) {
        this.numberOfNeighborsN = numberOfNeighborsN;
        this.sizeOfCombinationM = sizeOfCombinationM;
        this.numberOfInvariants = hasher.getNumberOfInvariants(sizeOfCombinationM);
        this.hasher = hasher;
        this.angles = new double[numberOfNeighborsN];
        this.allFeatures = new DogArray<LlahFeature>(() -> new LlahFeature(this.numberOfInvariants), LlahFeature::reset);
    }

    public void clearDocuments() {
        this.documents.reset();
        this.allFeatures.reset();
        this.hashTable.reset();
    }

    public void learnHashing(Iterable<List<Point2D_F64>> pointSets, int numDiscrete, int histogramLength, double maxInvariantValue) {
        double maxAllowed;
        int[] histogram = new int[histogramLength];
        double[] invariants = new double[this.numberOfInvariants];
        for (List<Point2D_F64> locations2D : pointSets) {
            this.nn.setPoints(locations2D, false);
            this.computeAllFeatures(locations2D, (idx, l) -> {
                this.hasher.computeInvariants(l, invariants, 0);
                for (int i = 0; i < invariants.length; ++i) {
                    int j;
                    int n = j = Math.min(histogram.length - 1, (int)((double)histogram.length * invariants[i] / maxInvariantValue));
                    histogram[n] = histogram[n] + 1;
                }
            });
        }
        double endFraction = (double)histogram[histogram.length - 1] / (double)IntStream.of(histogram).sum();
        if (endFraction > (maxAllowed = 0.5 / (double)numDiscrete)) {
            System.err.println("WARNING: last element in histogram has a significant count. " + endFraction + " > " + maxAllowed + " maxInvariantValue should be increased");
        }
        this.hasher.learnDiscretization(histogram, histogram.length, maxInvariantValue, numDiscrete);
    }

    public LlahDocument createDocument(List<Point2D_F64> locations2D) {
        this.checkListSize(locations2D);
        LlahDocument doc = this.documents.grow();
        doc.documentID = this.documents.size() - 1;
        doc.landmarks.copyAll(locations2D, (src, dst) -> dst.setTo((Point2D_F64)src));
        this.computeAllFeatures(locations2D, (idx, l) -> this.createProcessor(doc, idx));
        return doc;
    }

    public long computeMaxUniqueHashPerPoint() {
        long comboHash = Combinations.computeTotalCombinations(this.numberOfNeighborsN, this.sizeOfCombinationM);
        return comboHash * (long)this.sizeOfCombinationM;
    }

    private void createProcessor(LlahDocument doc, int idx) {
        LlahFeature feature = this.allFeatures.grow();
        this.hasher.computeHash(this.permuteM, feature);
        feature.landmarkID = idx;
        feature.documentID = doc.documentID;
        doc.features.add(feature);
        this.hashTable.add(feature);
    }

    void computeAllFeatures(List<Point2D_F64> dots, ProcessPermutation processor) {
        this.nn.setPoints(dots, false);
        for (int dotIdx = 0; dotIdx < dots.size(); ++dotIdx) {
            this.findNeighbors(dots.get(dotIdx));
            this.combinator.init(this.neighbors, this.sizeOfCombinationM);
            do {
                int i;
                this.setM.clear();
                for (i = 0; i < this.sizeOfCombinationM; ++i) {
                    this.setM.add(this.combinator.get(i));
                }
                for (i = 0; i < this.sizeOfCombinationM; ++i) {
                    this.permuteM.clear();
                    for (int j = 0; j < this.sizeOfCombinationM; ++j) {
                        int idx = (i + j) % this.sizeOfCombinationM;
                        this.permuteM.add(this.setM.get(idx));
                    }
                    processor.process(dotIdx, this.permuteM);
                }
            } while (this.combinator.next());
        }
    }

    void findNeighbors(Point2D_F64 target) {
        Point2D_F64 n;
        int i;
        this.search.findNearest(target, -1.0, this.numberOfNeighborsN + 1, this.resultsNN);
        this.neighbors.clear();
        for (i = 0; i < this.resultsNN.size; ++i) {
            n = (Point2D_F64)((NnData)this.resultsNN.get((int)i)).point;
            if (n == target) continue;
            this.neighbors.add(n);
        }
        for (i = 0; i < this.neighbors.size(); ++i) {
            n = this.neighbors.get(i);
            this.angles[i] = Math.atan2(n.y - target.y, n.x - target.x);
        }
        this.sorter.sort(this.angles, this.angles.length, this.neighbors);
    }

    public void lookupDocuments(List<Point2D_F64> dots, int minLandmarks, List<FoundDocument> output) {
        output.clear();
        if (dots.size() < this.numberOfNeighborsN + 1) {
            return;
        }
        this.votingBooths.reset();
        this.foundMap.clear();
        this.resultsStorage.reset();
        this.votingBooths.resize(dots.size());
        LlahFeature featureComputed = new LlahFeature(this.numberOfInvariants);
        this.computeAllFeatures(dots, (dotIdx, pointSet) -> this.lookupProcessor(pointSet, dotIdx, featureComputed, this.votingBooths));
        for (int dotIdx2 = 0; dotIdx2 < dots.size(); ++dotIdx2) {
            DotVotingBooth booth = (DotVotingBooth)this.votingBooths.get(dotIdx2);
            if (booth.votes.size == 0) continue;
            DotToLandmark best = (DotToLandmark)booth.votes.get(0);
            for (int i = 1; i < booth.votes.size; ++i) {
                DotToLandmark b = (DotToLandmark)booth.votes.get(i);
                if (b.count <= best.count) continue;
                best = b;
            }
            FoundDocument doc2 = this.foundMap.get(best.documentID);
            if (doc2 == null) {
                doc2 = this.resultsStorage.grow();
                doc2.init((LlahDocument)this.documents.get(best.documentID));
                this.foundMap.put(best.documentID, doc2);
            }
            if (doc2.landmarkHits.get(best.landmarkID) >= best.count) continue;
            doc2.landmarkHits.set(best.landmarkID, best.count);
            doc2.landmarkToDots.set(best.landmarkID, dotIdx2);
        }
        this.foundMap.forEachEntry((docID, doc) -> {
            if (doc.countSeenLandmarks() >= minLandmarks) {
                output.add((FoundDocument)doc);
            }
            return true;
        });
    }

    public boolean lookUpDocument(List<Point2D_F64> dots, FoundDocument output) {
        throw new RuntimeException("Implement");
    }

    void checkListSize(List<Point2D_F64> locations2D) {
        if (locations2D.size() < this.numberOfNeighborsN + 1) {
            throw new IllegalArgumentException("There needs to be at least " + (this.numberOfNeighborsN + 1) + " points");
        }
    }

    private void lookupProcessor(List<Point2D_F64> pointSet, int dotIdx, LlahFeature featureComputed, DogArray<DotVotingBooth> votingBooths) {
        DotVotingBooth booth = (DotVotingBooth)votingBooths.get(dotIdx);
        this.hasher.computeHash(pointSet, featureComputed);
        LlahFeature foundFeat = this.hashTable.lookup(featureComputed.hashCode);
        while (foundFeat != null) {
            if (featureComputed.doInvariantsMatch(foundFeat)) {
                DotToLandmark vote = booth.lookup(foundFeat.documentID, foundFeat.landmarkID);
                ++vote.count;
            }
            foundFeat = foundFeat.next;
        }
    }

    public int getNumberOfNeighborsN() {
        return this.numberOfNeighborsN;
    }

    public int getSizeOfCombinationM() {
        return this.sizeOfCombinationM;
    }

    public int getNumberOfInvariants() {
        return this.numberOfInvariants;
    }

    public LlahHasher getHasher() {
        return this.hasher;
    }

    public LlahHashTable getHashTable() {
        return this.hashTable;
    }

    public DogArray<LlahDocument> getDocuments() {
        return this.documents;
    }

    static interface ProcessPermutation {
        public void process(int var1, List<Point2D_F64> var2);
    }

    public static class DotVotingBooth {
        final DogArray<DotToLandmark> votes = new DogArray<DotToLandmark>(DotToLandmark::new);
        final TIntObjectHashMap<TIntObjectHashMap<DotToLandmark>> map = new TIntObjectHashMap();
        final DogArray<TIntObjectHashMap<DotToLandmark>> storageMaps = new DogArray<TIntObjectHashMap>(TIntObjectHashMap::new, TIntObjectHashMap::clear);

        public void reset() {
            this.votes.reset();
            this.map.clear();
            this.storageMaps.reset();
        }

        public DotToLandmark lookup(int documentID, int landmarkID) {
            DotToLandmark vote;
            TIntObjectHashMap<DotToLandmark> voteDoc = this.map.get(documentID);
            if (voteDoc == null) {
                voteDoc = this.storageMaps.grow();
                this.map.put(documentID, voteDoc);
            }
            if ((vote = voteDoc.get(landmarkID)) == null) {
                vote = this.votes.grow();
                vote.documentID = documentID;
                vote.landmarkID = landmarkID;
                vote.count = 0;
                voteDoc.put(landmarkID, vote);
            }
            return vote;
        }
    }

    public static class DotToLandmark {
        public int documentID;
        public int landmarkID;
        public int count;
    }

    public static class FoundDocument {
        public LlahDocument document;
        public final DogArray_I32 landmarkHits = new DogArray_I32();
        public final DogArray_I32 landmarkToDots = new DogArray_I32();

        public void init(LlahDocument document) {
            this.document = document;
            int totalLandmarks = document.landmarks.size;
            this.landmarkHits.resize(totalLandmarks);
            this.landmarkHits.fill(0);
            this.landmarkToDots.resize(totalLandmarks);
            this.landmarkToDots.fill(-1);
        }

        public boolean seenLandmark(int which) {
            return this.landmarkHits.get(which) > 0;
        }

        public void lookupMatches(DogArray<PointIndex2D_F64> matches) {
            matches.reset();
            for (int i = 0; i < this.landmarkHits.size; ++i) {
                if (this.landmarkHits.get(i) <= 0) continue;
                Point2D_F64 p = (Point2D_F64)this.document.landmarks.get(i);
                matches.grow().setTo(p.x, p.y, i);
            }
        }

        public int countSeenLandmarks() {
            int total = 0;
            for (int i = 0; i < this.landmarkHits.size; ++i) {
                if (this.landmarkHits.get(i) <= 0) continue;
                ++total;
            }
            return total;
        }

        public int countHits() {
            int total = 0;
            for (int i = 0; i < this.landmarkHits.size; ++i) {
                total += this.landmarkHits.get(i);
            }
            return total;
        }
    }

    public static class DotCount {
        public int dotIdx;
        public int counts;

        public void reset() {
            this.dotIdx = -1;
            this.counts = 0;
        }

        public int hashCode() {
            return this.dotIdx;
        }
    }
}

