/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class HysteresisEdgeTracePoints {
    public static final float MARK_TRAVERSED = -1.0f;
    private GrayF32 intensity;
    private GrayS8 direction;
    private final List<EdgeContour> contours = new ArrayList<EdgeContour>();
    private final List<EdgeSegment> open = new ArrayList<EdgeSegment>();
    private final DogArray<Point2D_I32> queuePoints = new DogArray<Point2D_I32>(Point2D_I32::new);
    private EdgeContour e;
    private float lower;

    public void process(GrayF32 intensity, GrayS8 direction, float lower, float upper) {
        if (lower < 0.0f) {
            throw new IllegalArgumentException("Lower must be >= 0!");
        }
        InputSanityCheck.checkSameShape(intensity, direction);
        this.intensity = intensity;
        this.direction = direction;
        this.lower = lower;
        this.queuePoints.reset();
        this.contours.clear();
        for (int y = 0; y < intensity.height; ++y) {
            int indexInten = intensity.startIndex + y * intensity.stride;
            int x = 0;
            while (x < intensity.width) {
                if (intensity.data[indexInten] >= upper) {
                    this.trace(x, y, indexInten);
                }
                ++x;
                ++indexInten;
            }
        }
    }

    protected void trace(int x, int y, int indexInten) {
        this.e = new EdgeContour();
        this.contours.add(this.e);
        this.addFirstSegment(x, y);
        this.intensity.data[indexInten] = -1.0f;
        block6: while (this.open.size() > 0) {
            EdgeSegment s = this.open.remove(this.open.size() - 1);
            Point2D_I32 p = s.points.get(0);
            indexInten = this.intensity.getIndex(p.x, p.y);
            int indexDir = this.direction.getIndex(p.x, p.y);
            boolean first = true;
            while (true) {
                int dy;
                int dx;
                switch (this.direction.data[indexDir]) {
                    case 0: {
                        dx = 0;
                        dy = 1;
                        break;
                    }
                    case 1: {
                        dx = 1;
                        dy = -1;
                        break;
                    }
                    case 2: {
                        dx = 1;
                        dy = 0;
                        break;
                    }
                    case -1: {
                        dx = 1;
                        dy = 1;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown direction: " + this.direction.data[indexDir]);
                    }
                }
                int indexForward = indexInten + dy * this.intensity.stride + dx;
                int indexBackward = indexInten - dy * this.intensity.stride - dx;
                int prevIndexDir = indexDir;
                boolean match = false;
                x = p.x;
                y = p.y;
                int fx = p.x + dx;
                int fy = p.y + dy;
                int bx = p.x - dx;
                int by = p.y - dy;
                if (this.intensity.isInBounds(fx, fy) && this.intensity.data[indexForward] >= this.lower) {
                    this.intensity.data[indexForward] = -1.0f;
                    p = this.queuePoints.grow();
                    p.setTo(fx, fy);
                    s.points.add(p);
                    match = true;
                    indexInten = indexForward;
                    indexDir = prevIndexDir + dy * this.intensity.stride + dx;
                }
                if (this.intensity.isInBounds(bx, by) && this.intensity.data[indexBackward] >= this.lower) {
                    this.intensity.data[indexBackward] = -1.0f;
                    if (match) {
                        this.startNewSegment(bx, by, s);
                    } else {
                        p = this.queuePoints.grow();
                        p.setTo(bx, by);
                        s.points.add(p);
                        match = true;
                        indexInten = indexBackward;
                        indexDir = prevIndexDir - dy * this.intensity.stride - dx;
                    }
                }
                if (!first && match) continue;
                boolean priorMatch = match;
                if (!(match = this.checkAllNeighbors(x, y, s, match))) continue block6;
                first = false;
                if (priorMatch) continue;
                p = s.points.get(s.points.size() - 1);
                indexInten = this.intensity.getIndex(p.x, p.y);
                indexDir = this.direction.getIndex(p.x, p.y);
            }
        }
    }

    private boolean checkAllNeighbors(int x, int y, EdgeSegment parent, boolean match) {
        match |= this.check(x + 1, y, parent, match);
        match |= this.check(x, y + 1, parent, match);
        match |= this.check(x - 1, y, parent, match);
        match |= this.check(x, y - 1, parent, match);
        match |= this.check(x + 1, y + 1, parent, match);
        match |= this.check(x + 1, y - 1, parent, match);
        match |= this.check(x - 1, y + 1, parent, match);
        match |= this.check(x - 1, y - 1, parent, match);
        return match;
    }

    private boolean check(int x, int y, EdgeSegment parent, boolean match) {
        int index;
        if (this.intensity.isInBounds(x, y) && this.intensity.data[index = this.intensity.getIndex(x, y)] >= this.lower) {
            this.intensity.data[index] = -1.0f;
            if (!match) {
                Point2D_I32 p = this.queuePoints.grow();
                p.setTo(x, y);
                parent.points.add(p);
            } else {
                this.startNewSegment(x, y, parent);
            }
            return true;
        }
        return false;
    }

    private void addFirstSegment(int x, int y) {
        Point2D_I32 p = this.queuePoints.grow();
        p.setTo(x, y);
        EdgeSegment s = new EdgeSegment();
        s.points.add(p);
        s.index = 0;
        s.parentPixel = -1;
        s.parent = -1;
        this.e.segments.add(s);
        this.open.add(s);
    }

    private void startNewSegment(int x, int y, EdgeSegment parent) {
        Point2D_I32 p = this.queuePoints.grow();
        p.setTo(x, y);
        EdgeSegment s = new EdgeSegment();
        s.parent = parent.index;
        s.parentPixel = parent.points.size() - 2;
        s.index = this.e.segments.size();
        s.points.add(p);
        this.e.segments.add(s);
        this.open.add(s);
    }

    public List<EdgeContour> getContours() {
        return this.contours;
    }
}

