/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.intensity.impl.FastCornerInterface;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.DiscretizedCircle;
import boofcv.struct.ListIntPoint2D;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import pabeles.concurrency.GrowArray;

public class FastCornerDetector_MT<T extends ImageGray<T>>
extends FastCornerDetector<T> {
    protected GrowArray<ThreadHelper> threadWorkspace;

    public FastCornerDetector_MT(FastCornerInterface<T> helper) {
        this.helper = helper;
        this.threadWorkspace = new GrowArray<ThreadHelper>(() -> new ThreadHelper(helper.newInstance()));
    }

    @Override
    public void process(T image, GrayF32 intensity) {
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets(3.0, ((ImageGray)image).stride);
        }
        BoofConcurrency.loopBlocks(3, ((ImageGray)image).height - 3, this.threadWorkspace, (thread, y0, y1) -> {
            thread.reset(image.width, image.height);
            ListIntPoint2D candidatesLow = thread.candidatesLow;
            ListIntPoint2D candidatesHigh = thread.candidatesHigh;
            FastCornerInterface<ImageGray> helper = thread.helper;
            helper.setImage((ImageGray)image, this.offsets);
            for (int y = y0; y < y1; ++y) {
                int indexIntensity = intensity.startIndex + y * intensity.stride + 3;
                int index = image.startIndex + y * image.stride + 3;
                int x = 3;
                while (x < image.width - 3) {
                    int result = helper.checkPixel(index);
                    if (result < 0) {
                        intensity.data[indexIntensity] = helper.scoreLower(index);
                        candidatesLow.add(x, y);
                    } else if (result > 0) {
                        intensity.data[indexIntensity] = helper.scoreUpper(index);
                        candidatesHigh.add(x, y);
                    } else {
                        intensity.data[indexIntensity] = 0.0f;
                    }
                    ++x;
                    ++index;
                    ++indexIntensity;
                }
            }
        });
        this.candidatesLow.configure(((ImageGray)image).width, ((ImageGray)image).height);
        this.candidatesHigh.configure(((ImageGray)image).width, ((ImageGray)image).height);
        for (int i = 0; i < this.threadWorkspace.size(); ++i) {
            ThreadHelper thread2 = this.threadWorkspace.get(i);
            this.candidatesLow.getPoints().addAll(thread2.candidatesLow.getPoints());
            this.candidatesHigh.getPoints().addAll(thread2.candidatesHigh.getPoints());
        }
    }

    @Override
    public void process(T image) {
        this.image = image;
        if (this.stride != ((ImageGray)image).stride) {
            this.stride = ((ImageGray)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets(3.0, ((ImageGray)image).stride);
        }
        BoofConcurrency.loopBlocks(3, ((ImageGray)image).height - 3, this.threadWorkspace, (thread, y0, y1) -> {
            thread.reset(image.width, image.height);
            ListIntPoint2D candidatesLow = thread.candidatesLow;
            ListIntPoint2D candidatesHigh = thread.candidatesHigh;
            FastCornerInterface<ImageGray> helper = thread.helper;
            helper.setImage((ImageGray)image, this.offsets);
            for (int y = y0; y < y1; ++y) {
                int index = image.startIndex + y * image.stride + 3;
                int x = 3;
                while (x < image.width - 3) {
                    int result = helper.checkPixel(index);
                    if (result < 0) {
                        candidatesLow.add(x, y);
                    } else if (result > 0) {
                        candidatesHigh.add(x, y);
                    }
                    ++x;
                    ++index;
                }
            }
        });
        this.candidatesLow.configure(((ImageGray)image).width, ((ImageGray)image).height);
        this.candidatesHigh.configure(((ImageGray)image).width, ((ImageGray)image).height);
        for (int i = 0; i < this.threadWorkspace.size(); ++i) {
            ThreadHelper thread2 = this.threadWorkspace.get(i);
            this.candidatesLow.getPoints().addAll(thread2.candidatesLow.getPoints());
            this.candidatesHigh.getPoints().addAll(thread2.candidatesHigh.getPoints());
        }
    }

    class ThreadHelper {
        final FastCornerInterface<T> helper;
        final ListIntPoint2D candidatesLow = new ListIntPoint2D();
        final ListIntPoint2D candidatesHigh = new ListIntPoint2D();

        public ThreadHelper(FastCornerInterface<T> helper) {
            this.helper = helper;
        }

        public void reset(int width, int height) {
            this.candidatesLow.configure(width, height);
            this.candidatesHigh.configure(width, height);
        }
    }
}

