/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;

public class ImplMedianCornerIntensity {
    public static void process(GrayF32 originalImage, GrayF32 medianImage, GrayF32 intensity) {
        int width = originalImage.width;
        int height = originalImage.height;
        for (int y = 0; y < height; ++y) {
            int indexOrig = originalImage.startIndex + originalImage.stride * y;
            int indexMed = medianImage.startIndex + medianImage.stride * y;
            int indexInten = intensity.startIndex + intensity.stride * y;
            for (int x = 0; x < width; ++x) {
                float val2 = originalImage.data[indexOrig++] - medianImage.data[indexMed++];
                intensity.data[indexInten++] = val2 < 0.0f ? -val2 : val2;
            }
        }
    }

    public static void process(GrayU8 originalImage, GrayU8 medianImage, GrayF32 intensity) {
        int width = originalImage.width;
        int height = originalImage.height;
        for (int y = 0; y < height; ++y) {
            int indexOrig = originalImage.startIndex + originalImage.stride * y;
            int indexMed = medianImage.startIndex + medianImage.stride * y;
            int indexInten = intensity.startIndex + intensity.stride * y;
            for (int x = 0; x < width; ++x) {
                int val2 = (originalImage.data[indexOrig++] & 0xFF) - (medianImage.data[indexMed++] & 0xFF);
                intensity.data[indexInten++] = val2 < 0 ? (float)(-val2) : (float)val2;
            }
        }
    }
}

