/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.GrayF32;
import org.ddogleg.struct.DogArray;

public class UnrollSiftScaleSpaceGradient {
    DogArray<ImageScale> scales = new DogArray<ImageScale>(ImageScale::new);
    ImageGradient<GrayF32, GrayF32> gradient = FactoryDerivative.three(GrayF32.class, null);
    private int numScales;

    public void process(SiftScaleSpace scaleSpace) {
        this.numScales = scaleSpace.getNumScales();
        int numScales = scaleSpace.getNumScales() * scaleSpace.getTotalOctaves();
        this.scales.reserve(numScales);
        this.scales.reset();
        for (int octaveIdx = 0; octaveIdx < scaleSpace.octaves.length && !scaleSpace.isOctaveTooSmall(octaveIdx); ++octaveIdx) {
            int octave = octaveIdx + scaleSpace.firstOctave;
            SiftScaleSpace.Octave o = scaleSpace.octaves[octaveIdx];
            for (int i = 0; i < scaleSpace.getNumScales(); ++i) {
                GrayF32 scaleImage = o.scales[i + 1];
                double sigma = scaleSpace.computeSigmaScale(octave, i);
                double pixelCurrentToInput = scaleSpace.pixelScaleCurrentToInput(octave);
                ImageScale scale = this.scales.grow();
                this.gradient.process(scaleImage, scale.derivX, scale.derivY);
                scale.imageToInput = pixelCurrentToInput;
                scale.sigma = sigma;
            }
        }
    }

    public ImageScale lookup(double sigma) {
        ImageScale best = null;
        double bestValue = Double.MAX_VALUE;
        for (int i = 0; i < this.scales.size(); ++i) {
            ImageScale image = (ImageScale)this.scales.get(i);
            double difference = Math.abs(sigma - image.sigma);
            if (!(difference < bestValue)) continue;
            bestValue = difference;
            best = image;
        }
        return best;
    }

    public GrayF32 getDerivX(byte octaveIdx, byte scaleIdx) {
        return ((ImageScale)this.scales.get((int)(octaveIdx * this.numScales + scaleIdx))).derivX;
    }

    public GrayF32 getDerivY(byte octaveIdx, byte scaleIdx) {
        return ((ImageScale)this.scales.get((int)(octaveIdx * this.numScales + scaleIdx))).derivY;
    }

    public static class ImageScale {
        public GrayF32 derivX = new GrayF32(1, 1);
        public GrayF32 derivY = new GrayF32(1, 1);
        public double imageToInput;
        public double sigma;
    }
}

