/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line.gridline;

import boofcv.alg.feature.detect.line.gridline.Edgel;
import georegression.fitting.line.FitLine_F32;
import georegression.metric.UtilAngle;
import georegression.struct.line.LinePolar2D_F32;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;

public class GridLineModelFitter
implements ModelGenerator<LinePolar2D_F32, Edgel> {
    float angleTol;

    public GridLineModelFitter(float angleTol) {
        this.angleTol = angleTol;
    }

    @Override
    public boolean generate(List<Edgel> dataSet, LinePolar2D_F32 model) {
        if (dataSet.size() == 2) {
            Edgel a = dataSet.get(0);
            Edgel b = (Edgel)dataSet.get(1);
            float dx = b.x - a.x;
            float dy = b.y - a.y;
            double lineAngle = UtilAngle.atanSafe(-dx, dy);
            if (UtilAngle.distHalf(lineAngle, a.theta) > (double)this.angleTol || UtilAngle.distHalf(lineAngle, b.theta) > (double)this.angleTol) {
                return false;
            }
        }
        FitLine_F32.polar(dataSet, model);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 2;
    }
}

