/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensity;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class FeatureSelectNBest<Point>
implements FeatureSelectLimitIntensity<Point> {
    int[] indexes = new int[1];
    float[] indexIntensity = new float[1];
    SampleIntensity<Point> sampler;

    public FeatureSelectNBest(SampleIntensity<Point> sampler) {
        this.sampler = sampler;
    }

    public FeatureSelectNBest() {
    }

    @Override
    public void select(GrayF32 intensity, int width, int height, boolean positive, @Nullable FastAccess<Point> prior, FastAccess<Point> detected, int limit, FastArray<Point> selected) {
        Object pt;
        int i;
        BoofMiscOps.checkTrue(limit > 0);
        selected.reset();
        if (detected.size <= limit) {
            selected.addAll(detected);
            return;
        }
        if (detected.size > this.indexes.length) {
            this.indexes = new int[detected.size];
            this.indexIntensity = new float[detected.size];
        }
        T[] points = detected.data;
        if (positive) {
            for (i = 0; i < detected.size; ++i) {
                pt = points[i];
                this.indexIntensity[i] = -this.sampler.sample(intensity, i, pt);
            }
        } else {
            for (i = 0; i < detected.size; ++i) {
                pt = points[i];
                this.indexIntensity[i] = this.sampler.sample(intensity, i, pt);
            }
        }
        QuickSelect.selectIndex(this.indexIntensity, limit, detected.size, this.indexes);
        selected.resize(limit);
        for (i = 0; i < limit; ++i) {
            selected.set(i, detected.data[this.indexes[i]]);
        }
    }

    @Override
    public void setSampler(SampleIntensity<Point> sampler) {
        this.sampler = sampler;
    }
}

