/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.SampleIntensity;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;

public class SampleIntensityImage {

    public static class F64
    implements SampleIntensity<Point2D_F64> {
        @Override
        public float sample(GrayF32 intensity, int index, Point2D_F64 p) {
            return intensity.unsafe_get((int)p.x, (int)p.y);
        }

        @Override
        public int getX(Point2D_F64 p) {
            return (int)p.x;
        }

        @Override
        public int getY(Point2D_F64 p) {
            return (int)p.y;
        }
    }

    public static class F32
    implements SampleIntensity<Point2D_F32> {
        @Override
        public float sample(GrayF32 intensity, int index, Point2D_F32 p) {
            return intensity.unsafe_get((int)p.x, (int)p.y);
        }

        @Override
        public int getX(Point2D_F32 p) {
            return (int)p.x;
        }

        @Override
        public int getY(Point2D_F32 p) {
            return (int)p.y;
        }
    }

    public static class I16
    implements SampleIntensity<Point2D_I16> {
        @Override
        public float sample(GrayF32 intensity, int index, Point2D_I16 p) {
            return intensity.unsafe_get(p.x, p.y);
        }

        @Override
        public int getX(Point2D_I16 p) {
            return p.x;
        }

        @Override
        public int getY(Point2D_I16 p) {
            return p.y;
        }
    }
}

