/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.BOverrideBlurImageOps;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner_MT;
import boofcv.alg.filter.blur.impl.ImplMedianSortEdgeNaive;
import boofcv.alg.filter.blur.impl.ImplMedianSortNaive;
import boofcv.alg.filter.blur.impl.ImplMedianSortNaive_MT;
import boofcv.alg.filter.convolve.ConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class BlurImageOps {
    public static GrayU8 mean(GrayU8 input, @Nullable GrayU8 output, int radius, @Nullable GrayU8 storage, @Nullable GrowArray<DogArray_I32> workVert) {
        return BlurImageOps.mean(input, output, radius, radius, storage, workVert);
    }

    public static GrayU8 mean(GrayU8 input, @Nullable GrayU8 output, int radiusX, int radiusY, @Nullable GrayU8 storage, @Nullable GrowArray<DogArray_I32> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanWeighted(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, storage, radiusX, radiusX * 2 + 1);
        ConvolveImageMean.vertical(storage, output, radiusY, radiusY * 2 + 1, workVert);
        return output;
    }

    public static GrayU8 meanB(GrayU8 input, @Nullable GrayU8 output, int radiusX, int radiusY, @Nullable ImageBorder_S32<GrayU8> binput, @Nullable GrayU8 storage, @Nullable GrowArray<DogArray_I32> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanBorder(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, binput, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, storage, radiusX, radiusX * 2 + 1, binput);
        ConvolveImageMean.vertical(storage, output, radiusY, radiusY * 2 + 1, binput, workVert);
        return output;
    }

    public static GrayU8 gaussian(GrayU8 input, @Nullable GrayU8 output, double sigma, int radius, @Nullable GrayU8 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static GrayU8 gaussian(GrayU8 input, @Nullable GrayU8 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable GrayU8 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_S32 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaX, radiusX);
            Kernel1D_S32 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, storage);
            ConvolveImageNormalized.vertical(kernelY, storage, output);
        }
        return output;
    }

    public static InterleavedU8 gaussian(InterleavedU8 input, @Nullable InterleavedU8 output, double sigma, int radius, @Nullable InterleavedU8 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static InterleavedU8 gaussian(InterleavedU8 input, @Nullable InterleavedU8 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable InterleavedU8 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_S32 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaX, radiusX);
            Kernel1D_S32 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, storage);
            ConvolveImageNormalized.vertical(kernelY, storage, output);
        }
        return output;
    }

    public static GrayU16 mean(GrayU16 input, @Nullable GrayU16 output, int radius, @Nullable GrayU16 storage, @Nullable GrowArray<DogArray_I32> workVert) {
        return BlurImageOps.mean(input, output, radius, radius, storage, workVert);
    }

    public static GrayU16 mean(GrayU16 input, @Nullable GrayU16 output, int radiusX, int radiusY, @Nullable GrayU16 storage, @Nullable GrowArray<DogArray_I32> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanWeighted(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, (GrayI16)storage, radiusX, radiusX * 2 + 1);
        ConvolveImageMean.vertical(storage, (GrayI16)output, radiusY, radiusY * 2 + 1, workVert);
        return output;
    }

    public static GrayU16 meanB(GrayU16 input, @Nullable GrayU16 output, int radiusX, int radiusY, @Nullable ImageBorder_S32<GrayU16> binput, @Nullable GrayU16 storage, @Nullable GrowArray<DogArray_I32> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanBorder(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, binput, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, (GrayI16)storage, radiusX, radiusX * 2 + 1, binput);
        ConvolveImageMean.vertical(storage, (GrayI16)output, radiusY, radiusY * 2 + 1, binput, workVert);
        return output;
    }

    public static GrayU16 gaussian(GrayU16 input, @Nullable GrayU16 output, double sigma, int radius, @Nullable GrayU16 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static GrayU16 gaussian(GrayU16 input, @Nullable GrayU16 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable GrayU16 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_S32 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaX, radiusX);
            Kernel1D_S32 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, (GrayI16)storage);
            ConvolveImageNormalized.vertical(kernelY, storage, (GrayI16)output);
        }
        return output;
    }

    public static InterleavedU16 gaussian(InterleavedU16 input, @Nullable InterleavedU16 output, double sigma, int radius, @Nullable InterleavedU16 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static InterleavedU16 gaussian(InterleavedU16 input, @Nullable InterleavedU16 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable InterleavedU16 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_S32 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaX, radiusX);
            Kernel1D_S32 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, (InterleavedI16)storage);
            ConvolveImageNormalized.vertical(kernelY, storage, (InterleavedI16)output);
        }
        return output;
    }

    public static GrayF32 mean(GrayF32 input, @Nullable GrayF32 output, int radius, @Nullable GrayF32 storage, @Nullable GrowArray<DogArray_F32> workVert) {
        return BlurImageOps.mean(input, output, radius, radius, storage, workVert);
    }

    public static GrayF32 mean(GrayF32 input, @Nullable GrayF32 output, int radiusX, int radiusY, @Nullable GrayF32 storage, @Nullable GrowArray<DogArray_F32> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanWeighted(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, storage, radiusX, radiusX * 2 + 1);
        ConvolveImageMean.vertical(storage, output, radiusY, radiusY * 2 + 1, workVert);
        return output;
    }

    public static GrayF32 meanB(GrayF32 input, @Nullable GrayF32 output, int radiusX, int radiusY, @Nullable ImageBorder_F32 binput, @Nullable GrayF32 storage, @Nullable GrowArray<DogArray_F32> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanBorder(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, binput, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, storage, radiusX, radiusX * 2 + 1, binput);
        ConvolveImageMean.vertical(storage, output, radiusY, radiusY * 2 + 1, binput, workVert);
        return output;
    }

    public static GrayF32 gaussian(GrayF32 input, @Nullable GrayF32 output, double sigma, int radius, @Nullable GrayF32 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static GrayF32 gaussian(GrayF32 input, @Nullable GrayF32 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable GrayF32 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F32 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigmaX, radiusX);
            Kernel1D_F32 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, storage);
            ConvolveImageNormalized.vertical(kernelY, storage, output);
        }
        return output;
    }

    public static InterleavedF32 gaussian(InterleavedF32 input, @Nullable InterleavedF32 output, double sigma, int radius, @Nullable InterleavedF32 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static InterleavedF32 gaussian(InterleavedF32 input, @Nullable InterleavedF32 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable InterleavedF32 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F32 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigmaX, radiusX);
            Kernel1D_F32 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, storage);
            ConvolveImageNormalized.vertical(kernelY, storage, output);
        }
        return output;
    }

    public static GrayF64 mean(GrayF64 input, @Nullable GrayF64 output, int radius, @Nullable GrayF64 storage, @Nullable GrowArray<DogArray_F64> workVert) {
        return BlurImageOps.mean(input, output, radius, radius, storage, workVert);
    }

    public static GrayF64 mean(GrayF64 input, @Nullable GrayF64 output, int radiusX, int radiusY, @Nullable GrayF64 storage, @Nullable GrowArray<DogArray_F64> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanWeighted(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, storage, radiusX, radiusX * 2 + 1);
        ConvolveImageMean.vertical(storage, output, radiusY, radiusY * 2 + 1, workVert);
        return output;
    }

    public static GrayF64 meanB(GrayF64 input, @Nullable GrayF64 output, int radiusX, int radiusY, @Nullable ImageBorder_F64 binput, @Nullable GrayF64 storage, @Nullable GrowArray<DogArray_F64> workVert) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMeanBorder(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY, binput, storage = InputSanityCheck.checkDeclare(input, storage));
        if (processed) {
            return output;
        }
        ConvolveImageMean.horizontal(input, storage, radiusX, radiusX * 2 + 1, binput);
        ConvolveImageMean.vertical(storage, output, radiusY, radiusY * 2 + 1, binput, workVert);
        return output;
    }

    public static GrayF64 gaussian(GrayF64 input, @Nullable GrayF64 output, double sigma, int radius, @Nullable GrayF64 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static GrayF64 gaussian(GrayF64 input, @Nullable GrayF64 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable GrayF64 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F64 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigmaX, radiusX);
            Kernel1D_F64 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, storage);
            ConvolveImageNormalized.vertical(kernelY, storage, output);
        }
        return output;
    }

    public static InterleavedF64 gaussian(InterleavedF64 input, @Nullable InterleavedF64 output, double sigma, int radius, @Nullable InterleavedF64 storage) {
        return BlurImageOps.gaussian(input, output, sigma, radius, sigma, radius, storage);
    }

    public static InterleavedF64 gaussian(InterleavedF64 input, @Nullable InterleavedF64 output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable InterleavedF64 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigmaX, radiusX, sigmaY, radiusY, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F64 kernelX = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigmaX, radiusX);
            Kernel1D_F64 kernelY = sigmaX == sigmaY && radiusX == radiusY ? kernelX : FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigmaY, radiusY);
            ConvolveImageNormalized.horizontal(kernelX, input, storage);
            ConvolveImageNormalized.vertical(kernelY, storage, output);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> gaussian(Planar<T> input, @Nullable Planar<T> output, double sigma, int radius, @Nullable T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.gaussian(input.getBand(band), ((Planar)output).getBand(band), sigma, radius, storage);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> gaussian(Planar<T> input, @Nullable Planar<T> output, double sigmaX, int radiusX, double sigmaY, int radiusY, @Nullable T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.gaussian(input.getBand(band), ((Planar)output).getBand(band), sigmaX, radiusX, sigmaY, radiusY, storage);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> mean(Planar<T> input, @Nullable Planar<T> output, int radius, @Nullable T storage, @Nullable GrowArray workVert) {
        return BlurImageOps.mean(input, output, radius, radius, storage, workVert);
    }

    public static <T extends ImageGray<T>> Planar<T> mean(Planar<T> input, @Nullable Planar<T> output, int radiusX, int radiusY, @Nullable T storage, @Nullable GrowArray workVert) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.mean(input.getBand(band), ((Planar)output).getBand(band), radiusX, radiusY, storage, workVert);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> meanB(Planar<T> input, @Nullable Planar<T> output, int radiusX, int radiusY, @Nullable ImageBorder<T> binput, @Nullable T storage, @Nullable GrowArray workVert) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.meanB(input.getBand(band), ((Planar)output).getBand(band), radiusX, radiusY, binput, storage, workVert);
        }
        return output;
    }

    public static GrayU8 median(GrayU8 input, @Nullable GrayU8 output, int radiusX, int radiusY, @Nullable GrowArray<DogArray_I32> work) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMedian(input, output, radiusX, radiusY);
        if (!processed) {
            work = BoofMiscOps.checkDeclare(work, DogArray_I32::new);
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplMedianHistogramInner_MT.process(input, output, radiusX, radiusY, work);
            } else {
                ImplMedianHistogramInner.process(input, output, radiusX, radiusY, work);
            }
            ImplMedianSortEdgeNaive.process(input, output, radiusX, radiusY, work.grow());
        }
        return output;
    }

    public static GrayF32 median(GrayF32 input, @Nullable GrayF32 output, int radiusX, int radiusY, @Nullable GrowArray<DogArray_F32> work) {
        if (radiusX <= 0 || radiusY <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMedian(input, output = InputSanityCheck.checkDeclare(input, output), radiusX, radiusY);
        if (!processed) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplMedianSortNaive_MT.process(input, output, radiusX, radiusY, work);
            } else {
                ImplMedianSortNaive.process(input, output, radiusX, radiusY, work);
            }
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> median(Planar<T> input, @Nullable Planar<T> output, int radiusX, int radiusY, @Nullable GrowArray<?> work) {
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), ((Planar)output).getBand(band), radiusX, radiusY, work);
        }
        return output;
    }
}

