/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;

public class ConvolveImageSparse {
    public static float horizontal(Kernel1D_F32 kernel, ImageBorder_F32 input, int x, int y) {
        int r = kernel.getRadius();
        int w = kernel.getWidth();
        float total = 0.0f;
        for (int i = 0; i < w; ++i) {
            total += input.get(x + i - r, y) * kernel.get(i);
        }
        return total;
    }

    public static float vertical(Kernel1D_F32 kernel, ImageBorder_F32 input, int x, int y) {
        int r = kernel.getRadius();
        int w = kernel.getWidth();
        float total = 0.0f;
        for (int i = 0; i < w; ++i) {
            total += input.get(x, y + i - r) * kernel.get(i);
        }
        return total;
    }

    public static float convolve(Kernel2D_F32 kernel, ImageBorder_F32 input, int x, int y) {
        int r = kernel.getRadius();
        int w = kernel.getWidth();
        float total = 0.0f;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < w; ++j) {
                total += input.get(x + j - r, y + i - r) * kernel.get(i, j);
            }
        }
        return total;
    }

    public static int horizontal(Kernel1D_S32 kernel, ImageBorder_S32 input, int x, int y) {
        int r = kernel.getRadius();
        int w = kernel.getWidth();
        int total = 0;
        for (int i = 0; i < w; ++i) {
            total += input.get(x + i - r, y) * kernel.get(i);
        }
        return total;
    }

    public static int vertical(Kernel1D_S32 kernel, ImageBorder_S32 input, int x, int y) {
        int r = kernel.getRadius();
        int w = kernel.getWidth();
        int total = 0;
        for (int i = 0; i < w; ++i) {
            total += input.get(x, y + i - r) * kernel.get(i);
        }
        return total;
    }

    public static int convolve(Kernel2D_S32 kernel, ImageBorder_S32 input, int x, int y) {
        int r = kernel.getRadius();
        int w = kernel.getWidth();
        int total = 0;
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < w; ++j) {
                total += input.get(x + j - r, y + i - r) * kernel.get(i, j);
            }
        }
        return total;
    }
}

