/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class DecomposeEssential {
    private final SingularValueDecomposition<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(3, 3, true, true, false);
    DMatrixRMaj U;
    DMatrixRMaj S;
    DMatrixRMaj V;
    List<Se3_F64> solutions = new ArrayList<Se3_F64>();
    DMatrixRMaj E_copy = new DMatrixRMaj(3, 3);
    DMatrixRMaj temp = new DMatrixRMaj(3, 3);
    DMatrixRMaj W = new DMatrixRMaj(3, 3);
    double translationLength;

    public DecomposeEssential() {
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.solutions.add(new Se3_F64());
        this.W.set(0, 1, -1.0);
        this.W.set(1, 0, 1.0);
        this.W.set(2, 2, 1.0);
    }

    public void decompose(DMatrixRMaj E) {
        if (this.svd.inputModified()) {
            this.E_copy.setTo(E);
            E = this.E_copy;
        }
        if (!this.svd.decompose(E)) {
            throw new RuntimeException("Svd some how failed");
        }
        this.U = this.svd.getU(this.U, false);
        this.V = this.svd.getV(this.V, false);
        this.S = this.svd.getW(this.S);
        SingularOps_DDRM.descendingOrder(this.U, false, this.S, this.V, false);
        this.translationLength = Math.abs(this.S.get(0, 0) + this.S.get(1, 1)) / 2.0;
        this.decompose(this.U, this.V);
    }

    public void decompose(DMatrixRMaj U, DMatrixRMaj V) {
        if (CommonOps_DDRM.det(U) < 0.0) {
            CommonOps_DDRM.scale(-1.0, U);
        }
        if (CommonOps_DDRM.det(V) < 0.0) {
            CommonOps_DDRM.scale(-1.0, V);
        }
        this.extractTransform(U, V, this.solutions.get(0), true, true);
        this.extractTransform(U, V, this.solutions.get(1), true, false);
        this.extractTransform(U, V, this.solutions.get(2), false, false);
        this.extractTransform(U, V, this.solutions.get(3), false, true);
    }

    public List<Se3_F64> getSolutions() {
        return this.solutions;
    }

    private void extractTransform(DMatrixRMaj U, DMatrixRMaj V, Se3_F64 se, boolean optionA, boolean optionB) {
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        if (optionA) {
            CommonOps_DDRM.multTransB(U, this.W, this.temp);
        } else {
            CommonOps_DDRM.mult(U, this.W, this.temp);
        }
        CommonOps_DDRM.multTransB(this.temp, V, R);
        T.x = U.get(0, 2);
        T.y = U.get(1, 2);
        T.z = U.get(2, 2);
        if (optionB) {
            T.scale(-1.0);
        }
    }

    public double getTranslationLength() {
        return this.translationLength;
    }
}

