/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class DecomposeProjectiveToMetric {
    protected QRDecomposition<DMatrixRMaj> qr = DecompositionFactory_DDRM.qr(3, 3);
    protected DMatrixRMaj Pv = SpecializedOps_DDRM.pivotMatrix(null, new int[]{2, 1, 0}, 3, false);
    protected DMatrixRMaj A_p = new DMatrixRMaj(3, 3);
    protected DMatrixRMaj A = new DMatrixRMaj(3, 3);
    protected SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(true, true, true);
    protected DMatrixRMaj P_metric = new DMatrixRMaj(3, 4);
    protected DMatrixRMaj P_rt = new DMatrixRMaj(3, 4);
    protected DMatrixRMaj K_inv = new DMatrixRMaj(3, 3);
    public double singularError;

    public boolean projectiveToMetricKnownK(DMatrixRMaj cameraMatrix, DMatrixRMaj H, DMatrixRMaj K, Se3_F64 worldToView) {
        this.singularError = 0.0;
        CommonOps_DDRM.mult(cameraMatrix, H, this.P_metric);
        CommonOps_DDRM.invert(K, this.K_inv);
        CommonOps_DDRM.mult(this.K_inv, this.P_metric, this.P_rt);
        CommonOps_DDRM.extract((DMatrix)this.P_rt, 0, 0, (DMatrix)worldToView.R);
        worldToView.T.x = this.P_rt.get(0, 3);
        worldToView.T.y = this.P_rt.get(1, 3);
        worldToView.T.z = this.P_rt.get(2, 3);
        DMatrixRMaj R = worldToView.R;
        if (!this.svd.decompose(R)) {
            return false;
        }
        CommonOps_DDRM.multTransB(this.svd.getU(null, false), this.svd.getV(null, false), R);
        double det = CommonOps_DDRM.det(R);
        if (det < 0.0) {
            CommonOps_DDRM.scale(-1.0, R);
            worldToView.T.scale(-1.0);
        }
        double[] sv = this.svd.getSingularValues();
        double sv_mag = (sv[0] + sv[1] + sv[2]) / 3.0;
        worldToView.T.divideIP(sv_mag);
        for (int i = 0; i < 3; ++i) {
            this.singularError += Math.abs(sv[i] - sv_mag);
        }
        return true;
    }

    public boolean projectiveToMetric(DMatrixRMaj cameraMatrix, DMatrixRMaj H, Se3_F64 worldToView, DMatrixRMaj K) {
        CommonOps_DDRM.mult(cameraMatrix, H, this.P_metric);
        return this.decomposeMetricCamera(this.P_metric, K, worldToView);
    }

    public boolean decomposeMetricCamera(DMatrixRMaj cameraMatrix, DMatrixRMaj K, Se3_F64 worldToView) {
        CommonOps_DDRM.extract(cameraMatrix, 0, 3, 0, 3, this.A, 0, 0);
        worldToView.T.setTo(cameraMatrix.get(0, 3), cameraMatrix.get(1, 3), cameraMatrix.get(2, 3));
        CommonOps_DDRM.mult(this.Pv, this.A, this.A_p);
        CommonOps_DDRM.transpose(this.A_p);
        if (!this.qr.decompose(this.A_p)) {
            return false;
        }
        this.qr.getQ(this.A, false);
        CommonOps_DDRM.multTransB(this.Pv, this.A, worldToView.R);
        this.qr.getR(K, false);
        CommonOps_DDRM.multTransB(this.Pv, K, this.A);
        CommonOps_DDRM.mult(this.A, this.Pv, K);
        for (int i = 0; i < 3; ++i) {
            if (!(K.get(i, i) < 0.0)) continue;
            CommonOps_DDRM.scaleCol(-1.0, K, i);
            CommonOps_DDRM.scaleRow(-1.0, worldToView.R, i);
        }
        if (CommonOps_DDRM.det(worldToView.R) < 0.0) {
            CommonOps_DDRM.scale(-1.0, worldToView.R);
            worldToView.T.scale(-1.0);
        }
        double scale = K.get(2, 2);
        CommonOps_DDRM.divide(K, scale);
        if (!CommonOps_DDRM.invert(K, this.A)) {
            return false;
        }
        GeometryMath_F64.mult(this.A, worldToView.T, worldToView.T);
        worldToView.T.divide(scale);
        return true;
    }

    public double getSingularError() {
        return this.singularError;
    }
}

